/*
 * Decompiled with CFR 0.152.
 */
package mantis.io.reactivex.netty.protocol.http.server;

import mantis.io.reactivex.netty.protocol.http.server.ErrorResponseGenerator;
import mantis.io.reactivex.netty.protocol.http.server.HttpServerRequest;
import mantis.io.reactivex.netty.protocol.http.server.HttpServerResponse;
import mantis.io.reactivex.netty.protocol.http.server.RequestHandler;
import rx.Observable;
import rx.functions.Func1;

public class RequestHandlerWithErrorMapper<I, O>
implements RequestHandler<I, O> {
    private Func1<Throwable, ErrorResponseGenerator<O>> errorMapper;
    private RequestHandler<I, O> handler;

    public static <I, O> RequestHandlerWithErrorMapper<I, O> from(RequestHandler<I, O> handler, Func1<Throwable, ErrorResponseGenerator<O>> errorMapper) {
        return new RequestHandlerWithErrorMapper<I, O>(handler, errorMapper);
    }

    public RequestHandlerWithErrorMapper(RequestHandler<I, O> handler, Func1<Throwable, ErrorResponseGenerator<O>> errorMapper) {
        this.handler = handler;
        this.errorMapper = errorMapper;
    }

    @Override
    public Observable<Void> handle(HttpServerRequest<I> request, final HttpServerResponse<O> response) {
        return this.handler.handle(request, response).onErrorResumeNext(new Func1<Throwable, Observable<Void>>(){

            @Override
            public Observable<Void> call(Throwable exception) {
                ErrorResponseGenerator generator2 = (ErrorResponseGenerator)RequestHandlerWithErrorMapper.this.errorMapper.call(exception);
                if (generator2 != null) {
                    generator2.updateResponse(response, exception);
                    return Observable.empty();
                }
                return Observable.error(exception);
            }
        });
    }
}

