/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.mantis.remote.observable;

import io.mantisrx.common.network.Endpoint;
import io.reactivex.mantis.remote.observable.EndpointChange;
import io.reactivex.mantis.remote.observable.EndpointInjector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.functions.Func1;

public class ToDeltaEndpointInjector
implements EndpointInjector {
    private static final Logger logger = LoggerFactory.getLogger(ToDeltaEndpointInjector.class);
    private Observable<List<Endpoint>> endpointObservable;
    private Observable<EndpointChange> reconcileChanges;

    public ToDeltaEndpointInjector(Observable<List<Endpoint>> endpointObservable) {
        this(endpointObservable, Observable.empty());
    }

    public ToDeltaEndpointInjector(Observable<List<Endpoint>> endpointObservable, Observable<EndpointChange> reconcileChanges) {
        this.endpointObservable = endpointObservable;
        this.reconcileChanges = reconcileChanges;
    }

    private String uniqueHost(String host, int port, String slotId) {
        return host + ":" + port + ":" + slotId;
    }

    private List<EndpointChange> changes(List<Endpoint> previous, List<Endpoint> current) {
        logger.info("Sets to evaluate for differences, current: " + current + " previous: " + previous);
        HashMap<String, Endpoint> previousSet = new HashMap<String, Endpoint>();
        for (Endpoint endpoint : previous) {
            previousSet.put(this.uniqueHost(endpoint.getHost(), endpoint.getPort(), endpoint.getSlotId()), endpoint);
        }
        LinkedList<EndpointChange> toAdd = new LinkedList<EndpointChange>();
        HashSet<String> completeCheck = new HashSet<String>();
        for (Endpoint endpoint : current) {
            String string2 = this.uniqueHost(endpoint.getHost(), endpoint.getPort(), endpoint.getSlotId());
            if (!previousSet.containsKey(string2)) {
                EndpointChange endpointChange = new EndpointChange(EndpointChange.Type.add, endpoint);
                toAdd.add(endpointChange);
                continue;
            }
            completeCheck.add(string2);
        }
        LinkedList<EndpointChange> toComplete = new LinkedList<EndpointChange>();
        for (Map.Entry entry : previousSet.entrySet()) {
            if (completeCheck.contains(entry.getKey())) continue;
            Endpoint endpoint = (Endpoint)entry.getValue();
            EndpointChange ceToCompletd = new EndpointChange(EndpointChange.Type.complete, endpoint);
            toComplete.add(ceToCompletd);
        }
        HashMap<String, EndpointChange> hashMap = new HashMap<String, EndpointChange>();
        for (EndpointChange endpointChange : toComplete) {
            hashMap.put(this.uniqueHost(endpointChange.getEndpoint().getHost(), endpointChange.getEndpoint().getPort(), endpointChange.getEndpoint().getSlotId()), endpointChange);
        }
        for (EndpointChange endpointChange : toAdd) {
            hashMap.put(this.uniqueHost(endpointChange.getEndpoint().getHost(), endpointChange.getEndpoint().getPort(), endpointChange.getEndpoint().getSlotId()), endpointChange);
        }
        logger.info("Differences to be applied: " + hashMap);
        return new ArrayList<EndpointChange>(hashMap.values());
    }

    @Override
    public Observable<EndpointChange> deltas() {
        return Observable.merge(this.reconcileChanges, this.endpointObservable.startWith(Collections.emptyList()).buffer(2, 1).flatMap(new Func1<List<List<Endpoint>>, Observable<EndpointChange>>(){

            @Override
            public Observable<EndpointChange> call(List<List<Endpoint>> previousAndCurrent) {
                if (previousAndCurrent.size() == 2) {
                    List<Endpoint> previous = previousAndCurrent.get(0);
                    List<Endpoint> current = previousAndCurrent.get(1);
                    return Observable.from(ToDeltaEndpointInjector.this.changes(previous, current));
                }
                return Observable.empty();
            }
        }));
    }
}

