/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.mantis.remote.observable;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RemoteRxEvent {
    private String name;
    private Type type;
    private byte[] data;
    private Map<String, String> subscriptionParameters;

    public RemoteRxEvent(String name2, Type type2, byte[] data2, Map<String, String> subscriptionParameters) {
        this.name = name2;
        this.type = type2;
        this.data = data2;
        this.subscriptionParameters = subscriptionParameters;
    }

    public static List<RemoteRxEvent> heartbeat() {
        ArrayList<RemoteRxEvent> list = new ArrayList<RemoteRxEvent>(1);
        list.add(new RemoteRxEvent(null, Type.heartbeat, null, null));
        return list;
    }

    public static RemoteRxEvent nonDataError(String name2, byte[] errorData) {
        return new RemoteRxEvent(null, Type.nonDataError, errorData, null);
    }

    public static RemoteRxEvent next(String name2, byte[] nextData) {
        return new RemoteRxEvent(name2, Type.next, nextData, null);
    }

    public static RemoteRxEvent completed(String name2) {
        return new RemoteRxEvent(name2, Type.completed, null, null);
    }

    public static RemoteRxEvent error(String name2, byte[] errorData) {
        return new RemoteRxEvent(name2, Type.error, errorData, null);
    }

    public static List<RemoteRxEvent> subscribed(String name2, Map<String, String> subscriptionParameters) {
        ArrayList<RemoteRxEvent> list = new ArrayList<RemoteRxEvent>(1);
        list.add(new RemoteRxEvent(name2, Type.subscribed, null, subscriptionParameters));
        return list;
    }

    public static List<RemoteRxEvent> unsubscribed(String name2) {
        ArrayList<RemoteRxEvent> list = new ArrayList<RemoteRxEvent>(1);
        list.add(new RemoteRxEvent(name2, Type.unsubscribed, null, null));
        return list;
    }

    public byte[] getData() {
        return this.data;
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    Map<String, String> getSubscribeParameters() {
        return this.subscriptionParameters;
    }

    public String toString() {
        return "RemoteRxEvent [name=" + this.name + ", type=" + (Object)((Object)this.type) + ", subscriptionParameters=" + this.subscriptionParameters + "]";
    }

    public static enum Type {
        next,
        completed,
        error,
        subscribed,
        unsubscribed,
        heartbeat,
        nonDataError;

    }
}

