/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.mantis.remote.observable;

import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;

public class PortSelectorWithinRange {
    private int start;
    private int end;
    private int attempts = 5;

    public PortSelectorWithinRange(int start, int end) {
        this.start = start;
        this.end = end;
    }

    public PortSelectorWithinRange(int start, int end, int attempts) {
        this.start = start;
        this.end = end;
        this.attempts = attempts;
    }

    public int acquirePort() {
        for (int i = 0; i < this.attempts; ++i) {
            int randomPort = this.start + (int)(Math.random() * (double)(this.end - this.start + 1));
            Socket socket = null;
            try {
                socket = new Socket("localhost", randomPort);
                continue;
            }
            catch (ConnectException e2) {
                int n = randomPort;
                return n;
            }
            catch (IOException e3) {
                throw new RuntimeException(e3);
            }
            finally {
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException e4) {
                    throw new RuntimeException(e4);
                }
            }
        }
        throw new RuntimeException("Could not acquire a port within range, after " + this.attempts + " attempts");
    }
}

