/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.mantis.remote.observable;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.reactivex.mantis.remote.observable.RemoteRxEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatHandler
extends ChannelDuplexHandler {
    static final Logger logger = LoggerFactory.getLogger(HeartbeatHandler.class);

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent e2 = (IdleStateEvent)evt;
            if (e2.state() == IdleState.READER_IDLE) {
                logger.warn("Read idle, due to missed heartbeats, closing connection: " + ctx.channel().remoteAddress());
                ctx.close();
            } else if (e2.state() == IdleState.WRITER_IDLE) {
                ctx.channel().writeAndFlush(RemoteRxEvent.heartbeat());
            }
        }
        super.userEventTriggered(ctx, evt);
    }
}

