/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.mantis.network.push;

import io.mantisrx.common.metrics.Gauge;
import io.mantisrx.common.metrics.MetricsRegistry;
import io.mantisrx.common.metrics.spectator.GaugeCallback;
import io.mantisrx.common.metrics.spectator.MetricGroupId;
import io.reactivex.mantis.network.push.AsyncConnection;
import io.reactivex.mantis.network.push.ConnectionGroup;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.functions.Action0;

public class ConnectionManager<T> {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionManager.class);
    private Map<String, ConnectionGroup<T>> managedConnections = new LinkedHashMap<String, ConnectionGroup<T>>();
    private MetricsRegistry metricsRegistry;
    private AtomicReference<Gauge> activeConnectionsRef = new AtomicReference<Object>(null);
    private Action0 doOnFirstConnection;
    private Action0 doOnZeroConnections;
    private Lock connectionState = new ReentrantLock();
    private AtomicBoolean subscribed = new AtomicBoolean();

    public ConnectionManager(MetricsRegistry metricsRegistry, Action0 doOnFirstConnection, Action0 doOnZeroConnections) {
        this.doOnFirstConnection = doOnFirstConnection;
        this.doOnZeroConnections = doOnZeroConnections;
        this.metricsRegistry = metricsRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int activeConnections() {
        this.connectionState.lock();
        try {
            int connections = 0;
            for (ConnectionGroup<T> group : this.managedConnections.values()) {
                connections += group.getConnections().size();
            }
            int n = connections;
            return n;
        }
        finally {
            this.connectionState.unlock();
        }
    }

    protected Gauge getActiveConnections(MetricGroupId metricsGroup) {
        this.activeConnectionsRef.compareAndSet(null, new GaugeCallback(metricsGroup, "activeConnections", () -> this.activeConnections()));
        return this.activeConnectionsRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<AsyncConnection<T>> connections(String groupId) {
        this.connectionState.lock();
        try {
            HashSet<AsyncConnection<T>> connections = new HashSet<AsyncConnection<T>>();
            ConnectionGroup<T> group = this.managedConnections.get(groupId);
            if (group != null) {
                connections.addAll(group.getConnections());
            }
            HashSet<AsyncConnection<T>> hashSet = connections;
            return hashSet;
        }
        finally {
            this.connectionState.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void successfulWrites(AsyncConnection<T> connection, Integer numWrites) {
        this.connectionState.lock();
        try {
            String groupId = connection.getGroupId();
            ConnectionGroup<T> current = this.managedConnections.get(groupId);
            if (current != null) {
                current.incrementSuccessfulWrites(numWrites);
            }
        }
        finally {
            this.connectionState.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void failedWrites(AsyncConnection<T> connection, Integer numWrites) {
        this.connectionState.lock();
        try {
            String groupId = connection.getGroupId();
            ConnectionGroup<T> current = this.managedConnections.get(groupId);
            if (current != null) {
                current.incrementFailedWrites(numWrites);
            }
        }
        finally {
            this.connectionState.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(AsyncConnection<T> connection) {
        this.connectionState.lock();
        try {
            ConnectionGroup newGroup;
            String groupId = connection.getGroupId();
            ConnectionGroup<T> current = this.managedConnections.get(groupId);
            if (current == null && (current = this.managedConnections.putIfAbsent(groupId, newGroup = new ConnectionGroup(groupId))) == null) {
                current = newGroup;
                this.metricsRegistry.registerAndGet(current.getMetrics());
            }
            current.addConnection(connection);
            logger.info("Connection added to group: " + groupId + ", connection: " + connection + ", group: " + current);
        }
        finally {
            this.connectionState.unlock();
        }
        if (this.subscribed.compareAndSet(false, true)) {
            logger.info("Calling callback when active connections is one");
            this.doOnFirstConnection.call();
            logger.info("Completed callback when active connections is one");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(AsyncConnection<T> connection) {
        this.connectionState.lock();
        try {
            String groupId = connection.getGroupId();
            ConnectionGroup<T> current = this.managedConnections.get(groupId);
            if (current != null) {
                current.removeConnection(connection);
                logger.info("Connection removed from group: " + groupId + ", connection: " + connection + ", group: " + current);
                if (current.isEmpty()) {
                    logger.info("Removing group: " + groupId + ", zero connections");
                    this.metricsRegistry.remove(current.getMetricsGroup());
                    this.managedConnections.remove(groupId);
                }
            }
        }
        finally {
            this.connectionState.unlock();
        }
        if (this.activeConnections() == 0 && this.subscribed.compareAndSet(true, false)) {
            logger.info("Connection Manager Calling callback when active connections is zero");
            this.doOnZeroConnections.call();
            logger.info("Completed callback when active connections is zero");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<AsyncConnection<T>> connections() {
        this.connectionState.lock();
        try {
            HashSet<AsyncConnection<T>> connections = new HashSet<AsyncConnection<T>>();
            for (ConnectionGroup<T> group : this.managedConnections.values()) {
                connections.addAll(group.getConnections());
            }
            HashSet<AsyncConnection<T>> hashSet = connections;
            return hashSet;
        }
        finally {
            this.connectionState.unlock();
        }
    }

    public Map<String, ConnectionGroup<T>> groups() {
        this.connectionState.lock();
        try {
            HashMap<String, ConnectionGroup<T>> hashMap = new HashMap<String, ConnectionGroup<T>>(this.managedConnections);
            return hashMap;
        }
        finally {
            this.connectionState.unlock();
        }
    }
}

