/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.mantis.network.push;

import java.util.List;
import rx.Observer;
import rx.functions.Func1;

public class AsyncConnection<T> {
    private String host;
    private int port;
    private String groupId;
    private String slotId;
    private String id;
    private Observer<List<byte[]>> subject;
    private Func1<T, Boolean> predicate;

    public AsyncConnection(String host, int port, String id, String slotId, String groupId, Observer<List<byte[]>> subject, Func1<T, Boolean> predicate) {
        this.host = host;
        this.port = port;
        this.id = id;
        this.groupId = groupId;
        this.subject = subject;
        this.predicate = predicate;
        this.slotId = slotId;
    }

    public Func1<T, Boolean> getPredicate() {
        return this.predicate;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getHost() {
        return this.host;
    }

    public String getSlotId() {
        return this.slotId;
    }

    public int getPort() {
        return this.port;
    }

    public String getId() {
        return this.id;
    }

    public void close() {
        this.subject.onCompleted();
    }

    public void write(List<byte[]> data2) {
        this.subject.onNext(data2);
    }

    public String toString() {
        return "AsyncConnection [host=" + this.host + ", port=" + this.port + ", groupId=" + this.groupId + ", slotId=" + this.slotId + ", id=" + this.id + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AsyncConnection other = (AsyncConnection)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

