/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;

public final class SystemPropertyUtil {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SystemPropertyUtil.class);

    public static boolean contains(String key2) {
        return SystemPropertyUtil.get(key2) != null;
    }

    public static String get(String key2) {
        return SystemPropertyUtil.get(key2, null);
    }

    public static String get(final String key2, String def) {
        if (key2 == null) {
            throw new NullPointerException("key");
        }
        if (key2.isEmpty()) {
            throw new IllegalArgumentException("key must not be empty.");
        }
        String value = null;
        try {
            value = System.getSecurityManager() == null ? System.getProperty(key2) : AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(key2);
                }
            });
        }
        catch (SecurityException e2) {
            logger.warn("Unable to retrieve a system property '{}'; default values will be used.", (Object)key2, (Object)e2);
        }
        if (value == null) {
            return def;
        }
        return value;
    }

    public static boolean getBoolean(String key2, boolean def) {
        String value = SystemPropertyUtil.get(key2);
        if (value == null) {
            return def;
        }
        if ((value = value.trim().toLowerCase()).isEmpty()) {
            return true;
        }
        if ("true".equals(value) || "yes".equals(value) || "1".equals(value)) {
            return true;
        }
        if ("false".equals(value) || "no".equals(value) || "0".equals(value)) {
            return false;
        }
        logger.warn("Unable to parse the boolean system property '{}':{} - using the default value: {}", key2, value, def);
        return def;
    }

    public static int getInt(String key2, int def) {
        String value = SystemPropertyUtil.get(key2);
        if (value == null) {
            return def;
        }
        value = value.trim();
        try {
            return Integer.parseInt(value);
        }
        catch (Exception exception) {
            logger.warn("Unable to parse the integer system property '{}':{} - using the default value: {}", key2, value, def);
            return def;
        }
    }

    public static long getLong(String key2, long def) {
        String value = SystemPropertyUtil.get(key2);
        if (value == null) {
            return def;
        }
        value = value.trim();
        try {
            return Long.parseLong(value);
        }
        catch (Exception exception) {
            logger.warn("Unable to parse the long integer system property '{}':{} - using the default value: {}", key2, value, def);
            return def;
        }
    }

    private SystemPropertyUtil() {
    }
}

