/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.jboss.netty.handler.timeout;

import io.mantisrx.shaded.org.jboss.netty.channel.ChannelFuture;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelFutureListener;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelHandler;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelHandlerContext;
import io.mantisrx.shaded.org.jboss.netty.channel.Channels;
import io.mantisrx.shaded.org.jboss.netty.channel.MessageEvent;
import io.mantisrx.shaded.org.jboss.netty.channel.SimpleChannelDownstreamHandler;
import io.mantisrx.shaded.org.jboss.netty.handler.timeout.WriteTimeoutException;
import io.mantisrx.shaded.org.jboss.netty.util.ExternalResourceReleasable;
import io.mantisrx.shaded.org.jboss.netty.util.Timeout;
import io.mantisrx.shaded.org.jboss.netty.util.Timer;
import io.mantisrx.shaded.org.jboss.netty.util.TimerTask;
import java.util.concurrent.TimeUnit;

@ChannelHandler.Sharable
public class WriteTimeoutHandler
extends SimpleChannelDownstreamHandler
implements ExternalResourceReleasable {
    static final WriteTimeoutException EXCEPTION = new WriteTimeoutException();
    private final Timer timer;
    private final long timeoutMillis;

    public WriteTimeoutHandler(Timer timer, int timeoutSeconds) {
        this(timer, timeoutSeconds, TimeUnit.SECONDS);
    }

    public WriteTimeoutHandler(Timer timer, long timeout, TimeUnit unit) {
        if (timer == null) {
            throw new NullPointerException("timer");
        }
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        this.timer = timer;
        this.timeoutMillis = timeout <= 0L ? 0L : Math.max(unit.toMillis(timeout), 1L);
    }

    public void releaseExternalResources() {
        this.timer.stop();
    }

    protected long getTimeoutMillis(MessageEvent e2) {
        return this.timeoutMillis;
    }

    public void writeRequested(ChannelHandlerContext ctx, MessageEvent e2) throws Exception {
        long timeoutMillis = this.getTimeoutMillis(e2);
        if (timeoutMillis > 0L) {
            ChannelFuture future2 = e2.getFuture();
            Timeout timeout = this.timer.newTimeout(new WriteTimeoutTask(ctx, future2), timeoutMillis, TimeUnit.MILLISECONDS);
            future2.addListener(new TimeoutCanceller(timeout));
        }
        super.writeRequested(ctx, e2);
    }

    protected void writeTimedOut(ChannelHandlerContext ctx) throws Exception {
        Channels.fireExceptionCaught(ctx, (Throwable)EXCEPTION);
    }

    private static final class TimeoutCanceller
    implements ChannelFutureListener {
        private final Timeout timeout;

        TimeoutCanceller(Timeout timeout) {
            this.timeout = timeout;
        }

        public void operationComplete(ChannelFuture future2) throws Exception {
            this.timeout.cancel();
        }
    }

    private final class WriteTimeoutTask
    implements TimerTask {
        private final ChannelHandlerContext ctx;
        private final ChannelFuture future;

        WriteTimeoutTask(ChannelHandlerContext ctx, ChannelFuture future2) {
            this.ctx = ctx;
            this.future = future2;
        }

        public void run(Timeout timeout) throws Exception {
            if (timeout.isCancelled()) {
                return;
            }
            if (!this.ctx.getChannel().isOpen()) {
                return;
            }
            if (this.future.setFailure(EXCEPTION)) {
                this.fireWriteTimeOut(this.ctx);
            }
        }

        private void fireWriteTimeOut(final ChannelHandlerContext ctx) {
            ctx.getPipeline().execute(new Runnable(){

                public void run() {
                    try {
                        WriteTimeoutHandler.this.writeTimedOut(ctx);
                    }
                    catch (Throwable t) {
                        Channels.fireExceptionCaught(ctx, t);
                    }
                }
            });
        }
    }
}

