/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.jboss.netty.handler.codec.http.websocket;

import io.mantisrx.shaded.org.jboss.netty.buffer.ChannelBuffer;
import io.mantisrx.shaded.org.jboss.netty.channel.Channel;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelHandlerContext;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.frame.TooLongFrameException;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.websocket.DefaultWebSocketFrame;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.websocket.WebSocketFrame;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.replay.ReplayingDecoder;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.replay.VoidEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class WebSocketFrameDecoder
extends ReplayingDecoder<VoidEnum> {
    public static final int DEFAULT_MAX_FRAME_SIZE = 16384;
    private final int maxFrameSize;
    private boolean receivedClosingHandshake;

    public WebSocketFrameDecoder() {
        this(16384);
    }

    public WebSocketFrameDecoder(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, VoidEnum state) throws Exception {
        if (this.receivedClosingHandshake) {
            buffer.skipBytes(this.actualReadableBytes());
            return null;
        }
        byte type2 = buffer.readByte();
        if ((type2 & 0x80) == 128) {
            return this.decodeBinaryFrame(type2, buffer);
        }
        return this.decodeTextFrame(type2, buffer);
    }

    private WebSocketFrame decodeBinaryFrame(int type2, ChannelBuffer buffer) throws TooLongFrameException {
        byte b;
        long frameSize = 0L;
        int lengthFieldSize = 0;
        do {
            b = buffer.readByte();
            frameSize <<= 7;
            if ((frameSize |= (long)(b & 0x7F)) > (long)this.maxFrameSize) {
                throw new TooLongFrameException();
            }
            if (++lengthFieldSize <= 8) continue;
            throw new TooLongFrameException();
        } while ((b & 0x80) == 128);
        if (type2 == 255 && frameSize == 0L) {
            this.receivedClosingHandshake = true;
        }
        return new DefaultWebSocketFrame(type2, buffer.readBytes((int)frameSize));
    }

    private WebSocketFrame decodeTextFrame(int type2, ChannelBuffer buffer) throws TooLongFrameException {
        int rbytes;
        int ridx = buffer.readerIndex();
        int delimPos = buffer.indexOf(ridx, ridx + (rbytes = this.actualReadableBytes()), (byte)-1);
        if (delimPos == -1) {
            if (rbytes > this.maxFrameSize) {
                throw new TooLongFrameException();
            }
            return null;
        }
        int frameSize = delimPos - ridx;
        if (frameSize > this.maxFrameSize) {
            throw new TooLongFrameException();
        }
        ChannelBuffer binaryData = buffer.readBytes(frameSize);
        buffer.skipBytes(1);
        return new DefaultWebSocketFrame(type2, binaryData);
    }
}

