/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper.server;

import io.mantisrx.shaded.org.apache.jute.BinaryInputArchive;
import io.mantisrx.shaded.org.apache.zookeeper.data.StatPersisted;
import io.mantisrx.shaded.org.apache.zookeeper.server.DataNode;
import io.mantisrx.shaded.org.apache.zookeeper.server.DataTree;
import io.mantisrx.shaded.org.apache.zookeeper.server.persistence.FileSnap;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class SnapshotFormatter {
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("USAGE: SnapshotFormatter snapshot_file");
            System.exit(2);
        }
        new SnapshotFormatter().run(args[0]);
    }

    public void run(String snapshotFileName) throws IOException {
        CheckedInputStream is2 = new CheckedInputStream(new BufferedInputStream(new FileInputStream(snapshotFileName)), new Adler32());
        BinaryInputArchive ia = BinaryInputArchive.getArchive(is2);
        FileSnap fileSnap = new FileSnap(null);
        DataTree dataTree = new DataTree();
        HashMap<Long, Integer> sessions = new HashMap<Long, Integer>();
        fileSnap.deserialize(dataTree, sessions, ia);
        this.printDetails(dataTree, sessions);
    }

    private void printDetails(DataTree dataTree, Map<Long, Integer> sessions) {
        this.printZnodeDetails(dataTree);
        this.printSessionDetails(dataTree, sessions);
    }

    private void printZnodeDetails(DataTree dataTree) {
        System.out.println(String.format("ZNode Details (count=%d):", dataTree.getNodeCount()));
        this.printZnode(dataTree, "/");
        System.out.println("----");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printZnode(DataTree dataTree, String name2) {
        Set<String> children2;
        System.out.println("----");
        DataNode n = dataTree.getNode(name2);
        DataNode dataNode = n;
        synchronized (dataNode) {
            System.out.println(name2);
            this.printStat(n.stat);
            if (n.data != null) {
                System.out.println("  dataLength = " + n.data.length);
            } else {
                System.out.println("  no data");
            }
            children2 = n.getChildren();
        }
        for (String child : children2) {
            this.printZnode(dataTree, name2 + (name2.equals("/") ? "" : "/") + child);
        }
    }

    private void printSessionDetails(DataTree dataTree, Map<Long, Integer> sessions) {
        System.out.println("Session Details (sid, timeout, ephemeralCount):");
        for (Map.Entry<Long, Integer> e2 : sessions.entrySet()) {
            long sid = e2.getKey();
            System.out.println(String.format("%#016x, %d, %d", sid, e2.getValue(), dataTree.getEphemerals(sid).size()));
        }
    }

    private void printStat(StatPersisted stat) {
        this.printHex("cZxid", stat.getCzxid());
        System.out.println("  ctime = " + new Date(stat.getCtime()).toString());
        this.printHex("mZxid", stat.getMzxid());
        System.out.println("  mtime = " + new Date(stat.getMtime()).toString());
        this.printHex("pZxid", stat.getPzxid());
        System.out.println("  cversion = " + stat.getCversion());
        System.out.println("  dataVersion = " + stat.getVersion());
        System.out.println("  aclVersion = " + stat.getAversion());
        this.printHex("ephemeralOwner", stat.getEphemeralOwner());
    }

    private void printHex(String prefix, long value) {
        System.out.println(String.format("  %s = %#016x", prefix, value));
    }
}

