/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper.common;

import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathTrie {
    private static final Logger LOG = LoggerFactory.getLogger(PathTrie.class);
    private final TrieNode rootNode = new TrieNode(null);

    public void addPath(String path2) {
        if (path2 == null) {
            return;
        }
        String[] pathComponents = path2.split("/");
        TrieNode parent = this.rootNode;
        String part = null;
        if (pathComponents.length <= 1) {
            throw new IllegalArgumentException("Invalid path " + path2);
        }
        for (int i = 1; i < pathComponents.length; ++i) {
            part = pathComponents[i];
            if (parent.getChild(part) == null) {
                parent.addChild(part, new TrieNode(parent));
            }
            parent = parent.getChild(part);
        }
        parent.setProperty(true);
    }

    public void deletePath(String path2) {
        if (path2 == null) {
            return;
        }
        String[] pathComponents = path2.split("/");
        TrieNode parent = this.rootNode;
        String part = null;
        if (pathComponents.length <= 1) {
            throw new IllegalArgumentException("Invalid path " + path2);
        }
        for (int i = 1; i < pathComponents.length; ++i) {
            part = pathComponents[i];
            if (parent.getChild(part) == null) {
                return;
            }
            parent = parent.getChild(part);
            LOG.info("{}", (Object)parent);
        }
        TrieNode realParent = parent.getParent();
        realParent.deleteChild(part);
    }

    public String findMaxPrefix(String path2) {
        if (path2 == null) {
            return null;
        }
        if ("/".equals(path2)) {
            return path2;
        }
        String[] pathComponents = path2.split("/");
        TrieNode parent = this.rootNode;
        ArrayList<String> components = new ArrayList<String>();
        if (pathComponents.length <= 1) {
            throw new IllegalArgumentException("Invalid path " + path2);
        }
        String part = null;
        StringBuilder sb = new StringBuilder();
        int lastindex = -1;
        for (int i = 1; i < pathComponents.length && parent.getChild(pathComponents[i]) != null; ++i) {
            part = pathComponents[i];
            parent = parent.getChild(part);
            components.add(part);
            if (!parent.getProperty()) continue;
            lastindex = i - 1;
        }
        for (int j = 0; j < lastindex + 1; ++j) {
            sb.append("/" + (String)components.get(j));
        }
        return sb.toString();
    }

    public void clear() {
        for (String child : this.rootNode.getChildren()) {
            this.rootNode.deleteChild(child);
        }
    }

    static class TrieNode {
        boolean property = false;
        final HashMap<String, TrieNode> children = new HashMap();
        TrieNode parent = null;

        private TrieNode(TrieNode parent) {
            this.parent = parent;
        }

        TrieNode getParent() {
            return this.parent;
        }

        void setParent(TrieNode parent) {
            this.parent = parent;
        }

        void setProperty(boolean prop) {
            this.property = prop;
        }

        boolean getProperty() {
            return this.property;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addChild(String childName, TrieNode node2) {
            HashMap<String, TrieNode> hashMap = this.children;
            synchronized (hashMap) {
                if (this.children.containsKey(childName)) {
                    return;
                }
                this.children.put(childName, node2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void deleteChild(String childName) {
            HashMap<String, TrieNode> hashMap = this.children;
            synchronized (hashMap) {
                if (!this.children.containsKey(childName)) {
                    return;
                }
                TrieNode childNode = this.children.get(childName);
                if (childNode.getChildren().length == 1) {
                    childNode.setParent(null);
                    this.children.remove(childName);
                } else {
                    childNode.setProperty(false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TrieNode getChild(String childName) {
            HashMap<String, TrieNode> hashMap = this.children;
            synchronized (hashMap) {
                if (!this.children.containsKey(childName)) {
                    return null;
                }
                return this.children.get(childName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String[] getChildren() {
            HashMap<String, TrieNode> hashMap = this.children;
            synchronized (hashMap) {
                return this.children.keySet().toArray(new String[0]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Children of trienode: ");
            HashMap<String, TrieNode> hashMap = this.children;
            synchronized (hashMap) {
                for (String str2 : this.children.keySet()) {
                    sb.append(" " + str2);
                }
            }
            return sb.toString();
        }
    }
}

