/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.curator.framework.recipes.nodes;

import io.mantisrx.shaded.org.apache.curator.framework.CuratorFramework;
import io.mantisrx.shaded.org.apache.curator.framework.CuratorFrameworkFactory;
import io.mantisrx.shaded.org.apache.curator.framework.recipes.cache.ChildData;
import io.mantisrx.shaded.org.apache.curator.framework.recipes.cache.PathChildrenCache;
import io.mantisrx.shaded.org.apache.curator.framework.recipes.nodes.PersistentEphemeralNode;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.base.Preconditions;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.base.Throwables;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect.ImmutableMap;
import io.mantisrx.shaded.org.apache.curator.utils.CloseableUtils;
import io.mantisrx.shaded.org.apache.curator.utils.ThreadUtils;
import io.mantisrx.shaded.org.apache.curator.utils.ZKPaths;
import java.io.Closeable;
import java.util.Map;

public class GroupMember
implements Closeable {
    private final PersistentEphemeralNode pen;
    private final PathChildrenCache cache;
    private final String thisId;

    public GroupMember(CuratorFramework client, String membershipPath, String thisId) {
        this(client, membershipPath, thisId, CuratorFrameworkFactory.getLocalAddress());
    }

    public GroupMember(CuratorFramework client, String membershipPath, String thisId, byte[] payload) {
        this.thisId = Preconditions.checkNotNull(thisId, "thisId cannot be null");
        this.cache = this.newPathChildrenCache(client, membershipPath);
        this.pen = this.newPersistentEphemeralNode(client, membershipPath, thisId, payload);
    }

    public void start() {
        this.pen.start();
        try {
            this.cache.start();
        }
        catch (Exception e2) {
            ThreadUtils.checkInterrupted(e2);
            Throwables.propagate(e2);
        }
    }

    public void setThisData(byte[] data2) {
        try {
            this.pen.setData(data2);
        }
        catch (Exception e2) {
            ThreadUtils.checkInterrupted(e2);
            Throwables.propagate(e2);
        }
    }

    @Override
    public void close() {
        CloseableUtils.closeQuietly(this.cache);
        CloseableUtils.closeQuietly(this.pen);
    }

    public Map<String, byte[]> getCurrentMembers() {
        ImmutableMap.Builder<String, byte[]> builder = ImmutableMap.builder();
        boolean thisIdAdded = false;
        for (ChildData data2 : this.cache.getCurrentData()) {
            String id = this.idFromPath(data2.getPath());
            thisIdAdded = thisIdAdded || id.equals(this.thisId);
            builder.put(id, data2.getData());
        }
        if (!thisIdAdded) {
            builder.put(this.thisId, this.pen.getData());
        }
        return builder.build();
    }

    public String idFromPath(String path2) {
        return ZKPaths.getNodeFromPath(path2);
    }

    protected PersistentEphemeralNode newPersistentEphemeralNode(CuratorFramework client, String membershipPath, String thisId, byte[] payload) {
        return new PersistentEphemeralNode(client, PersistentEphemeralNode.Mode.EPHEMERAL, ZKPaths.makePath(membershipPath, thisId), payload);
    }

    protected PathChildrenCache newPathChildrenCache(CuratorFramework client, String membershipPath) {
        return new PathChildrenCache(client, membershipPath, true);
    }
}

