/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.curator.framework.recipes.locks;

import io.mantisrx.shaded.org.apache.curator.framework.CuratorFramework;
import io.mantisrx.shaded.org.apache.curator.framework.recipes.leader.LeaderLatch;
import io.mantisrx.shaded.org.apache.curator.framework.recipes.locks.Reaper;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.annotations.VisibleForTesting;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.base.Preconditions;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect.Sets;
import io.mantisrx.shaded.org.apache.curator.utils.CloseableScheduledExecutorService;
import io.mantisrx.shaded.org.apache.curator.utils.CloseableUtils;
import io.mantisrx.shaded.org.apache.curator.utils.PathUtils;
import io.mantisrx.shaded.org.apache.curator.utils.ThreadUtils;
import io.mantisrx.shaded.org.apache.curator.utils.ZKPaths;
import io.mantisrx.shaded.org.apache.zookeeper.data.Stat;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ChildReaper
implements Closeable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Reaper reaper;
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);
    private final CuratorFramework client;
    private final Collection<String> paths = Sets.newConcurrentHashSet();
    private volatile Iterator<String> pathIterator = null;
    private final Reaper.Mode mode;
    private final CloseableScheduledExecutorService executor;
    private final int reapingThresholdMs;
    private final LeaderLatch leaderLatch;
    private final Set<String> lockSchema;
    private final AtomicInteger maxChildren = new AtomicInteger(-1);
    private volatile Future<?> task;

    public ChildReaper(CuratorFramework client, String path2, Reaper.Mode mode) {
        this(client, path2, mode, ChildReaper.newExecutorService(), Reaper.DEFAULT_REAPING_THRESHOLD_MS, null);
    }

    public ChildReaper(CuratorFramework client, String path2, Reaper.Mode mode, int reapingThresholdMs) {
        this(client, path2, mode, ChildReaper.newExecutorService(), reapingThresholdMs, null);
    }

    public ChildReaper(CuratorFramework client, String path2, Reaper.Mode mode, ScheduledExecutorService executor, int reapingThresholdMs) {
        this(client, path2, mode, executor, reapingThresholdMs, null);
    }

    public ChildReaper(CuratorFramework client, String path2, Reaper.Mode mode, ScheduledExecutorService executor, int reapingThresholdMs, String leaderPath) {
        this(client, path2, mode, executor, reapingThresholdMs, leaderPath, Collections.emptySet());
    }

    public ChildReaper(CuratorFramework client, String path2, Reaper.Mode mode, ScheduledExecutorService executor, int reapingThresholdMs, String leaderPath, Set<String> lockSchema) {
        this.client = client;
        this.mode = mode;
        this.executor = new CloseableScheduledExecutorService(executor);
        this.reapingThresholdMs = reapingThresholdMs;
        this.leaderLatch = leaderPath != null ? new LeaderLatch(client, leaderPath) : null;
        this.reaper = new Reaper(client, executor, reapingThresholdMs, this.leaderLatch);
        this.lockSchema = lockSchema;
        this.addPath(path2);
    }

    public void start() throws Exception {
        Preconditions.checkState(this.state.compareAndSet(State.LATENT, State.STARTED), "Cannot be started more than once");
        this.task = this.executor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                ChildReaper.this.doWork();
            }
        }, this.reapingThresholdMs, this.reapingThresholdMs, TimeUnit.MILLISECONDS);
        if (this.leaderLatch != null) {
            this.leaderLatch.start();
        }
        this.reaper.start();
    }

    @Override
    public void close() throws IOException {
        if (this.state.compareAndSet(State.STARTED, State.CLOSED)) {
            CloseableUtils.closeQuietly(this.reaper);
            if (this.leaderLatch != null) {
                CloseableUtils.closeQuietly(this.leaderLatch);
            }
            this.task.cancel(true);
        }
    }

    public ChildReaper addPath(String path2) {
        this.paths.add(PathUtils.validatePath(path2));
        return this;
    }

    public boolean removePath(String path2) {
        return this.paths.remove(PathUtils.validatePath(path2));
    }

    public void setMaxChildren(int maxChildren) {
        this.maxChildren.set(maxChildren);
    }

    public static ScheduledExecutorService newExecutorService() {
        return ThreadUtils.newFixedThreadScheduledPool(2, "ChildReaper");
    }

    @VisibleForTesting
    protected void warnMaxChildren(String path2, Stat stat) {
        this.log.warn(String.format("Skipping %s as it has too many children: %d", path2, stat.getNumChildren()));
    }

    private void doWork() {
        if (this.shouldDoWork()) {
            if (this.pathIterator == null || !this.pathIterator.hasNext()) {
                this.pathIterator = this.paths.iterator();
            }
            while (this.pathIterator.hasNext()) {
                String path2 = this.pathIterator.next();
                try {
                    Stat stat;
                    int maxChildren = this.maxChildren.get();
                    if (maxChildren > 0 && (stat = (Stat)this.client.checkExists().forPath(path2)) != null && stat.getNumChildren() > maxChildren) {
                        this.warnMaxChildren(path2, stat);
                        continue;
                    }
                    List children2 = (List)this.client.getChildren().forPath(path2);
                    this.log.info(String.format("Found %d children for %s", children2.size(), path2));
                    for (String name2 : children2) {
                        String childPath = ZKPaths.makePath(path2, name2);
                        this.addPathToReaperIfEmpty(childPath);
                        for (String subNode : this.lockSchema) {
                            this.addPathToReaperIfEmpty(ZKPaths.makePath(childPath, subNode));
                        }
                    }
                }
                catch (Exception e2) {
                    ThreadUtils.checkInterrupted(e2);
                    this.log.error("Could not get children for path: " + path2, e2);
                }
            }
        }
    }

    private void addPathToReaperIfEmpty(String path2) throws Exception {
        Stat stat = (Stat)this.client.checkExists().forPath(path2);
        if (stat != null && stat.getNumChildren() == 0) {
            this.log.info("Adding " + path2);
            this.reaper.addPath(path2, this.mode);
        }
    }

    private boolean shouldDoWork() {
        return this.leaderLatch == null || this.leaderLatch.hasLeadership();
    }

    private static enum State {
        LATENT,
        STARTED,
        CLOSED;

    }
}

