/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.io.vavr.jackson.datatype.deserialize;

import io.mantisrx.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JavaType;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import io.mantisrx.shaded.io.vavr.jackson.datatype.deserialize.ArrayDeserializer;
import io.vavr.collection.HashSet;
import io.vavr.collection.LinkedHashSet;
import io.vavr.collection.Set;
import io.vavr.collection.SortedSet;
import io.vavr.collection.TreeSet;
import java.util.List;

class SetDeserializer
extends ArrayDeserializer<Set<?>> {
    private static final long serialVersionUID = 1L;
    private final JavaType javaType;

    SetDeserializer(JavaType valueType, boolean deserializeNullAsEmptyCollection) {
        super(valueType, 1, deserializeNullAsEmptyCollection);
        this.javaType = valueType;
    }

    @Override
    Set<?> create(List<Object> result, DeserializationContext ctx) throws JsonMappingException {
        if (SortedSet.class.isAssignableFrom(this.javaType.getRawClass())) {
            SetDeserializer.checkContainedTypeIsComparable(ctx, this.javaType.containedTypeOrUnknown(0));
            return TreeSet.ofAll((o1, o2) -> ((Comparable)o1).compareTo(o2), result);
        }
        if (LinkedHashSet.class.isAssignableFrom(this.javaType.getRawClass())) {
            return LinkedHashSet.ofAll(result);
        }
        return HashSet.ofAll(result);
    }
}

