/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.com.fasterxml.jackson.datatype.jsr310.deser;

import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonFormat;
import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonParser;
import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonToken;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import io.mantisrx.shaded.com.fasterxml.jackson.datatype.jsr310.deser.JSR310DateTimeDeserializerBase;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;

public class YearMonthDeserializer
extends JSR310DateTimeDeserializerBase<YearMonth> {
    private static final long serialVersionUID = 1L;
    public static final YearMonthDeserializer INSTANCE = new YearMonthDeserializer();

    public YearMonthDeserializer() {
        this(DateTimeFormatter.ofPattern("uuuu-MM"));
    }

    public YearMonthDeserializer(DateTimeFormatter formatter2) {
        super(YearMonth.class, formatter2);
    }

    protected YearMonthDeserializer(YearMonthDeserializer base, Boolean leniency) {
        super(base, leniency);
    }

    protected YearMonthDeserializer withDateFormat(DateTimeFormatter dtf) {
        return new YearMonthDeserializer(dtf);
    }

    @Override
    protected YearMonthDeserializer withLeniency(Boolean leniency) {
        return new YearMonthDeserializer(this, leniency);
    }

    protected YearMonthDeserializer withShape(JsonFormat.Shape shape) {
        return this;
    }

    @Override
    public YearMonth deserialize(JsonParser parser2, DeserializationContext context) throws IOException {
        if (parser2.hasToken(JsonToken.VALUE_STRING)) {
            return this._fromString(parser2, context, parser2.getText());
        }
        if (parser2.isExpectedStartObjectToken()) {
            return this._fromString(parser2, context, context.extractScalarFromObject(parser2, this, this.handledType()));
        }
        if (parser2.isExpectedStartArrayToken()) {
            JsonToken t = parser2.nextToken();
            if (t == JsonToken.END_ARRAY) {
                return null;
            }
            if ((t == JsonToken.VALUE_STRING || t == JsonToken.VALUE_EMBEDDED_OBJECT) && context.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                YearMonth parsed = this.deserialize(parser2, context);
                if (parser2.nextToken() != JsonToken.END_ARRAY) {
                    this.handleMissingEndArrayForSingle(parser2, context);
                }
                return parsed;
            }
            if (t != JsonToken.VALUE_NUMBER_INT) {
                this._reportWrongToken(context, JsonToken.VALUE_NUMBER_INT, "years");
            }
            int year = parser2.getIntValue();
            int month = parser2.nextIntValue(-1);
            if (month == -1) {
                if (!parser2.hasToken(JsonToken.VALUE_NUMBER_INT)) {
                    this._reportWrongToken(context, JsonToken.VALUE_NUMBER_INT, "months");
                }
                month = parser2.getIntValue();
            }
            if (parser2.nextToken() != JsonToken.END_ARRAY) {
                throw context.wrongTokenException(parser2, this.handledType(), JsonToken.END_ARRAY, "Expected array to end");
            }
            return YearMonth.of(year, month);
        }
        if (parser2.hasToken(JsonToken.VALUE_EMBEDDED_OBJECT)) {
            return (YearMonth)parser2.getEmbeddedObject();
        }
        return (YearMonth)this._handleUnexpectedToken(context, parser2, JsonToken.VALUE_STRING, JsonToken.START_ARRAY);
    }

    protected YearMonth _fromString(JsonParser p, DeserializationContext ctxt, String string0) throws IOException {
        String string2 = string0.trim();
        if (string2.length() == 0) {
            return (YearMonth)this._fromEmptyString(p, ctxt, string2);
        }
        try {
            return YearMonth.parse(string2, this._formatter);
        }
        catch (DateTimeException e2) {
            return (YearMonth)this._handleDateTimeException(ctxt, e2, string2);
        }
    }
}

