/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.parameter.type;

import io.mantisrx.runtime.parameter.ParameterDecoder;
import io.mantisrx.runtime.parameter.ParameterDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;

public class EnumCSVParameter<T extends Enum<T>>
extends ParameterDefinition.Builder<EnumSet<T>> {
    private final Class<T> clazz;

    public EnumCSVParameter(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public ParameterDecoder<EnumSet<T>> decoder() {
        return new ParameterDecoder<EnumSet<T>>(){

            @Override
            public EnumSet<T> decode(String value) {
                String[] values = value.split(",");
                if (values.length == 0) {
                    return EnumSet.noneOf(EnumCSVParameter.this.clazz);
                }
                ArrayList enumVals = new ArrayList();
                for (String val2 : values) {
                    String trim2 = val2.trim();
                    if (trim2.length() <= 0) continue;
                    enumVals.add(Enum.valueOf(EnumCSVParameter.this.clazz, trim2));
                }
                EnumSet<Enum> set2 = EnumSet.noneOf(EnumCSVParameter.this.clazz);
                for (Enum val3 : enumVals) {
                    set2.add(val3);
                }
                return set2;
            }
        };
    }

    @Override
    public String getTypeDescription() {
        List ts = Arrays.stream(this.clazz.getEnumConstants()).map(x -> x.name()).collect(Collectors.toList());
        return "Comma separated set of values: " + String.join((CharSequence)",", ts);
    }

    @Override
    public Class<EnumSet<T>> classType() {
        return null;
    }
}

