/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.descriptor;

import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class StageScalingPolicy
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int stage;
    private final int min;
    private final int max;
    private final boolean enabled;
    private final int increment;
    private final int decrement;
    private final long coolDownSecs;
    private final Map<ScalingReason, Strategy> strategies;

    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public StageScalingPolicy(@JsonProperty(value="stage") int stage, @JsonProperty(value="min") int min2, @JsonProperty(value="max") int max2, @JsonProperty(value="increment") int increment, @JsonProperty(value="decrement") int decrement, @JsonProperty(value="coolDownSecs") long coolDownSecs, @JsonProperty(value="strategies") Map<ScalingReason, Strategy> strategies) {
        this.stage = stage;
        this.min = min2;
        this.max = Math.max(max2, min2);
        this.enabled = min2 != max2 && strategies != null && !strategies.isEmpty();
        this.increment = Math.max(increment, 1);
        this.decrement = Math.max(decrement, 1);
        this.coolDownSecs = coolDownSecs;
        this.strategies = strategies == null ? new HashMap<ScalingReason, Strategy>() : new HashMap<ScalingReason, Strategy>(strategies);
    }

    public int getStage() {
        return this.stage;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getIncrement() {
        return this.increment;
    }

    public int getDecrement() {
        return this.decrement;
    }

    public long getCoolDownSecs() {
        return this.coolDownSecs;
    }

    public Map<ScalingReason, Strategy> getStrategies() {
        return Collections.unmodifiableMap(this.strategies);
    }

    public String toString() {
        return "StageScalingPolicy{stage=" + this.stage + ", min=" + this.min + ", max=" + this.max + ", enabled=" + this.enabled + ", increment=" + this.increment + ", decrement=" + this.decrement + ", coolDownSecs=" + this.coolDownSecs + ", strategies=" + this.strategies + '}';
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.coolDownSecs ^ this.coolDownSecs >>> 32);
        result = 31 * result + this.decrement;
        result = 31 * result + (this.enabled ? 1231 : 1237);
        result = 31 * result + this.increment;
        result = 31 * result + this.max;
        result = 31 * result + this.min;
        result = 31 * result + this.stage;
        result = 31 * result + (this.strategies == null ? 0 : this.strategies.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StageScalingPolicy other = (StageScalingPolicy)obj;
        if (this.coolDownSecs != other.coolDownSecs) {
            return false;
        }
        if (this.decrement != other.decrement) {
            return false;
        }
        if (this.enabled != other.enabled) {
            return false;
        }
        if (this.increment != other.increment) {
            return false;
        }
        if (this.max != other.max) {
            return false;
        }
        if (this.min != other.min) {
            return false;
        }
        if (this.stage != other.stage) {
            return false;
        }
        return !(this.strategies == null ? other.strategies != null : !this.strategies.equals(other.strategies));
    }

    public static class Strategy
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final ScalingReason reason;
        private final double scaleDownBelowPct;
        private final double scaleUpAbovePct;
        private final RollingCount rollingCount;

        @JsonCreator
        @JsonIgnoreProperties(ignoreUnknown=true)
        public Strategy(@JsonProperty(value="reason") ScalingReason reason, @JsonProperty(value="scaleDownBelowPct") double scaleDownBelowPct, @JsonProperty(value="scaleUpAbovePct") double scaleUpAbovePct, @JsonProperty(value="rollingCount") RollingCount rollingCount) {
            this.reason = reason;
            this.scaleDownBelowPct = scaleDownBelowPct;
            this.scaleUpAbovePct = Math.max(scaleDownBelowPct, scaleUpAbovePct);
            this.rollingCount = rollingCount == null ? new RollingCount(1, 1) : rollingCount;
        }

        public String toString() {
            return "StageScalingPolicy.Strategy(reason=" + (Object)((Object)this.getReason()) + ", scaleDownBelowPct=" + this.getScaleDownBelowPct() + ", scaleUpAbovePct=" + this.getScaleUpAbovePct() + ", rollingCount=" + this.getRollingCount() + ")";
        }

        public ScalingReason getReason() {
            return this.reason;
        }

        public double getScaleDownBelowPct() {
            return this.scaleDownBelowPct;
        }

        public double getScaleUpAbovePct() {
            return this.scaleUpAbovePct;
        }

        public RollingCount getRollingCount() {
            return this.rollingCount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Strategy)) {
                return false;
            }
            Strategy other = (Strategy)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getScaleDownBelowPct(), other.getScaleDownBelowPct()) != 0) {
                return false;
            }
            if (Double.compare(this.getScaleUpAbovePct(), other.getScaleUpAbovePct()) != 0) {
                return false;
            }
            ScalingReason this$reason = this.getReason();
            ScalingReason other$reason = other.getReason();
            if (this$reason == null ? other$reason != null : !((Object)((Object)this$reason)).equals((Object)other$reason)) {
                return false;
            }
            RollingCount this$rollingCount = this.getRollingCount();
            RollingCount other$rollingCount = other.getRollingCount();
            return !(this$rollingCount == null ? other$rollingCount != null : !((Object)this$rollingCount).equals(other$rollingCount));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Strategy;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $scaleDownBelowPct = Double.doubleToLongBits(this.getScaleDownBelowPct());
            result = result * 59 + (int)($scaleDownBelowPct >>> 32 ^ $scaleDownBelowPct);
            long $scaleUpAbovePct = Double.doubleToLongBits(this.getScaleUpAbovePct());
            result = result * 59 + (int)($scaleUpAbovePct >>> 32 ^ $scaleUpAbovePct);
            ScalingReason $reason = this.getReason();
            result = result * 59 + ($reason == null ? 43 : ((Object)((Object)$reason)).hashCode());
            RollingCount $rollingCount = this.getRollingCount();
            result = result * 59 + ($rollingCount == null ? 43 : ((Object)$rollingCount).hashCode());
            return result;
        }
    }

    public static class RollingCount
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int count;
        private final int of;

        @JsonCreator
        public RollingCount(@JsonProperty(value="count") int count2, @JsonProperty(value="of") int of) {
            this.count = count2;
            this.of = of;
        }

        public int getCount() {
            return this.count;
        }

        public int getOf() {
            return this.of;
        }

        public String toString() {
            return "StageScalingPolicy.RollingCount(count=" + this.getCount() + ", of=" + this.getOf() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RollingCount)) {
                return false;
            }
            RollingCount other = (RollingCount)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCount() != other.getCount()) {
                return false;
            }
            return this.getOf() == other.getOf();
        }

        protected boolean canEqual(Object other) {
            return other instanceof RollingCount;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCount();
            result = result * 59 + this.getOf();
            return result;
        }
    }

    public static enum ScalingReason {
        CPU,
        Memory,
        Network,
        DataDrop,
        KafkaLag,
        UserDefined,
        KafkaProcessed,
        Clutch,
        ClutchExperimental,
        ClutchRps,
        RPS,
        JVMMemory,
        SourceJobDrop;

    }
}

