/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime;

import io.mantisrx.runtime.KeyValueStageConfig;
import io.mantisrx.runtime.NettyCodec;
import io.mantisrx.runtime.StageConfig;
import io.mantisrx.runtime.computation.ToGroupComputation;
import io.mantisrx.runtime.parameter.ParameterDefinition;
import io.reactivex.netty.codec.Codec;
import java.util.Collections;
import java.util.List;

public class ScalarToGroup<T, K, R>
extends KeyValueStageConfig<T, K, R> {
    private ToGroupComputation<T, K, R> computation;
    private long keyExpireTimeSeconds;

    ScalarToGroup(ToGroupComputation<T, K, R> computation, Config<T, K, R> config, Codec<T> inputCodec) {
        this(computation, config, NettyCodec.fromNetty(inputCodec));
    }

    ScalarToGroup(ToGroupComputation<T, K, R> computation, Config<T, K, R> config, io.mantisrx.common.codec.Codec<T> inputCodec) {
        super(((Config)config).description, null, inputCodec, ((Config)config).keyCodec, ((Config)config).codec, ((Config)config).inputStrategy, ((Config)config).parameters);
        this.computation = computation;
        this.keyExpireTimeSeconds = ((Config)config).keyExpireTimeSeconds;
    }

    public ToGroupComputation<T, K, R> getComputation() {
        return this.computation;
    }

    public long getKeyExpireTimeSeconds() {
        return this.keyExpireTimeSeconds;
    }

    public static class Config<T, K, R> {
        private io.mantisrx.common.codec.Codec<R> codec;
        private io.mantisrx.common.codec.Codec<K> keyCodec;
        private String description;
        private StageConfig.INPUT_STRATEGY inputStrategy = StageConfig.INPUT_STRATEGY.CONCURRENT;
        private long keyExpireTimeSeconds = Long.MAX_VALUE;
        private List<ParameterDefinition<?>> parameters = Collections.emptyList();

        public Config<T, K, R> codec(Codec<R> codec) {
            this.codec = NettyCodec.fromNetty(codec);
            return this;
        }

        public Config<T, K, R> codec(io.mantisrx.common.codec.Codec<R> codec) {
            this.codec = codec;
            return this;
        }

        public Config<T, K, R> keyCodec(io.mantisrx.common.codec.Codec<K> keyCodec) {
            this.keyCodec = keyCodec;
            return this;
        }

        public Config<T, K, R> keyExpireTimeSeconds(long seconds) {
            this.keyExpireTimeSeconds = seconds;
            return this;
        }

        public Config<T, K, R> serialInput() {
            this.inputStrategy = StageConfig.INPUT_STRATEGY.SERIAL;
            return this;
        }

        public Config<T, K, R> concurrentInput() {
            this.inputStrategy = StageConfig.INPUT_STRATEGY.CONCURRENT;
            return this;
        }

        public Config<T, K, R> description(String description) {
            this.description = description;
            return this;
        }

        public io.mantisrx.common.codec.Codec<R> getCodec() {
            return this.codec;
        }

        public io.mantisrx.common.codec.Codec<K> getKeyCodec() {
            return this.keyCodec;
        }

        public String getDescription() {
            return this.description;
        }

        public StageConfig.INPUT_STRATEGY getInputStrategy() {
            return this.inputStrategy;
        }

        public long getKeyExpireTimeSeconds() {
            return this.keyExpireTimeSeconds;
        }

        public Config<T, K, R> withParameters(List<ParameterDefinition<?>> params) {
            this.parameters = params;
            return this;
        }
    }
}

