/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.connector.iceberg.sink.writer.pool;

import io.mantisrx.connector.iceberg.sink.writer.IcebergWriter;
import io.mantisrx.connector.iceberg.sink.writer.config.WriterConfig;
import io.mantisrx.connector.iceberg.sink.writer.factory.IcebergWriterFactory;
import io.mantisrx.connector.iceberg.sink.writer.pool.IcebergWriterPool;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.data.Record;

public class FixedIcebergWriterPool
implements IcebergWriterPool {
    private final IcebergWriterFactory factory;
    private final Map<StructLike, IcebergWriter> pool;
    private final long flushFrequencyBytes;
    private final int maximumPoolSize;

    public FixedIcebergWriterPool(IcebergWriterFactory factory, WriterConfig writerConfig) {
        this(factory, writerConfig.getWriterFlushFrequencyBytes(), writerConfig.getWriterMaximumPoolSize());
    }

    public FixedIcebergWriterPool(IcebergWriterFactory factory, long flushFrequencyBytes, int maximumPoolSize) {
        this.factory = factory;
        this.flushFrequencyBytes = flushFrequencyBytes;
        this.maximumPoolSize = maximumPoolSize;
        this.pool = new HashMap<StructLike, IcebergWriter>(this.maximumPoolSize);
    }

    @Override
    public void open(StructLike partition2) throws IOException {
        if (this.pool.size() >= this.maximumPoolSize) {
            throw new IOException("problem opening writer; maximum writer pool size (" + this.maximumPoolSize + ") exceeded");
        }
        if (!this.isClosed(partition2)) {
            return;
        }
        IcebergWriter writer2 = this.factory.newIcebergWriter();
        writer2.open(partition2);
        this.pool.put(partition2, writer2);
    }

    @Override
    public void write(StructLike partition2, Record record) {
        IcebergWriter writer2 = this.pool.get(partition2);
        if (writer2 == null) {
            throw new RuntimeException("writer does not exist in writer pool");
        }
        writer2.write(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataFile close(StructLike partition2) throws IOException, UncheckedIOException {
        IcebergWriter writer2 = this.pool.get(partition2);
        if (writer2 == null) {
            throw new RuntimeException("writer does not exist in writer pool");
        }
        try {
            DataFile dataFile = writer2.close();
            return dataFile;
        }
        finally {
            this.pool.remove(partition2);
        }
    }

    @Override
    public List<DataFile> closeAll() throws IOException, UncheckedIOException {
        ArrayList<DataFile> dataFiles = new ArrayList<DataFile>();
        for (StructLike partition2 : this.pool.keySet()) {
            DataFile dataFile = this.close(partition2);
            if (dataFile == null) continue;
            dataFiles.add(dataFile);
        }
        return dataFiles;
    }

    @Override
    public Set<StructLike> getWriters() {
        return this.pool.keySet();
    }

    @Override
    public Set<StructLike> getFlushableWriters() {
        return this.pool.entrySet().stream().filter(entry -> ((IcebergWriter)entry.getValue()).length() >= this.flushFrequencyBytes).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    @Override
    public boolean isClosed(StructLike partition2) {
        return !this.pool.containsKey(partition2);
    }
}

