/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.connector.iceberg.sink.committer.metrics;

import io.mantisrx.common.metrics.Counter;
import io.mantisrx.common.metrics.Gauge;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.MetricsRegistry;
import io.mantisrx.common.metrics.Timer;
import java.util.concurrent.TimeUnit;

public class CommitterMetrics {
    public static final String INVOCATION_COUNT = "invocationCount";
    private final Counter invocationCount;
    public static final String COMMIT_SUCCESS_COUNT = "commitSuccessCount";
    private final Counter commitSuccessCount;
    public static final String COMMIT_FAILURE_COUNT = "commitFailureCount";
    private final Counter commitFailureCount;
    public static final String COMMIT_LATENCY_MSEC = "commitLatencyMsec";
    private final Timer commitLatencyMsec;
    public static final String COMMIT_BATCH_SIZE = "commitBatchSize";
    private final Gauge commitBatchSize;

    public CommitterMetrics() {
        Metrics metrics = new Metrics.Builder().name(CommitterMetrics.class.getCanonicalName()).addCounter(INVOCATION_COUNT).addCounter(COMMIT_SUCCESS_COUNT).addCounter(COMMIT_FAILURE_COUNT).addTimer(COMMIT_LATENCY_MSEC).addGauge(COMMIT_BATCH_SIZE).build();
        metrics = MetricsRegistry.getInstance().registerAndGet(metrics);
        this.invocationCount = metrics.getCounter(INVOCATION_COUNT);
        this.commitSuccessCount = metrics.getCounter(COMMIT_SUCCESS_COUNT);
        this.commitFailureCount = metrics.getCounter(COMMIT_FAILURE_COUNT);
        this.commitLatencyMsec = metrics.getTimer(COMMIT_LATENCY_MSEC);
        this.commitBatchSize = metrics.getGauge(COMMIT_BATCH_SIZE);
    }

    public void setGauge(String metric, long value) {
        switch (metric) {
            case "commitBatchSize": {
                this.commitBatchSize.set(value);
                break;
            }
        }
    }

    public void record(String metric, long amount, TimeUnit unit) {
        switch (metric) {
            case "commitLatencyMsec": {
                this.commitLatencyMsec.record(amount, unit);
                break;
            }
        }
    }

    public void increment(String metric) {
        switch (metric) {
            case "invocationCount": {
                this.invocationCount.increment();
                break;
            }
            case "commitSuccessCount": {
                this.commitSuccessCount.increment();
                break;
            }
            case "commitFailureCount": {
                this.commitFailureCount.increment();
                break;
            }
        }
    }

    public void increment(String metric, long value) {
        switch (metric) {
            case "invocationCount": {
                this.invocationCount.increment(value);
                break;
            }
            case "commitSuccessCount": {
                this.commitSuccessCount.increment(value);
                break;
            }
            case "commitFailureCount": {
                this.commitFailureCount.increment(value);
                break;
            }
            case "commitBatchSize": {
                this.commitBatchSize.increment(value);
                break;
            }
        }
    }
}

