/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.common.network;

import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Tag;
import io.mantisrx.common.network.Endpoint;
import io.reactivx.mantis.operators.DropOperator;
import java.util.Optional;
import mantis.io.reactivex.netty.channel.ObservableConnection;
import rx.Observable;
import rx.subjects.PublishSubject;
import rx.subjects.SerializedSubject;
import rx.subjects.Subject;

public class WritableEndpoint<T>
extends Endpoint
implements Comparable<WritableEndpoint<T>> {
    private Subject<T, T> subject = new SerializedSubject<T, T>(PublishSubject.create());
    private ObservableConnection<?, ?> connection;

    public WritableEndpoint(String host, int port, String slotId) {
        this(host, port, slotId, null);
    }

    public WritableEndpoint(String host, int port, String slotId, ObservableConnection<?, ?> connection) {
        super(host, port, slotId);
        this.connection = connection;
    }

    public WritableEndpoint(String host, int port) {
        super(host, port);
    }

    public void write(T value) {
        this.subject.onNext(value);
    }

    public void explicitClose() {
        if (this.connection != null) {
            this.connection.close(true);
        }
    }

    public void complete() {
        this.subject.onCompleted();
        this.explicitClose();
    }

    public Observable<T> read() {
        return this.subject.lift(new DropOperator("outgoing_subject", new Tag[]{new BasicTag("slotId", Optional.ofNullable(this.slotId).orElse("none"))}));
    }

    @Override
    public String toString() {
        return "WritableEndpoint [" + super.toString() + "]";
    }

    public void error(Throwable e2) {
        this.subject.onError(e2);
        this.explicitClose();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.slotId == null ? 0 : this.slotId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Endpoint other = (Endpoint)obj;
        return !(this.slotId == null ? other.slotId != null : !this.slotId.equals(other.slotId));
    }

    @Override
    public int compareTo(WritableEndpoint<T> o) {
        if (this.equals(o)) {
            return 0;
        }
        return o.getSlotId().compareTo(this.getSlotId());
    }
}

