/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.common.metrics.spectator;

import com.netflix.spectator.api.Tag;
import java.util.Arrays;
import java.util.Collections;

public class MetricGroupId {
    private final String name;
    private final Iterable<Tag> tags;
    private final String id;

    public MetricGroupId(String name2) {
        this(name2, Collections.emptyList());
    }

    public MetricGroupId(String name2, Iterable<Tag> tags) {
        this.name = name2;
        this.tags = tags;
        this.id = this.createId(name2, tags);
    }

    public MetricGroupId(String name2, Tag ... tags) {
        this(name2, Arrays.asList(tags));
    }

    private String createId(String name2, Iterable<Tag> tags) {
        StringBuilder buf = new StringBuilder();
        buf.append(name2);
        for (Tag t : tags) {
            buf.append(':').append(t.key()).append('=').append(t.value());
        }
        return buf.toString();
    }

    public String name() {
        return this.name;
    }

    public Iterable<Tag> tags() {
        return this.tags;
    }

    public String id() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricGroupId that = (MetricGroupId)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) {
            return false;
        }
        return this.id != null ? this.id.equals(that.id) : that.id == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "MetricGroupId{name='" + this.name + '\'' + ", tags=" + this.tags + ", id='" + this.id + '\'' + '}';
    }
}

