/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.common.metrics.spectator;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.patterns.PolledMeter;
import io.mantisrx.common.metrics.Gauge;
import io.mantisrx.common.metrics.spectator.MetricGroupId;
import io.mantisrx.common.metrics.spectator.MetricId;
import io.mantisrx.common.metrics.spectator.SpectatorRegistryFactory;
import rx.functions.Func0;

public class GaugeCallback
implements Gauge {
    private final MetricId metricId;
    private final Id spectatorId;
    private Func0<Double> valueCallback;

    public GaugeCallback(MetricId metricId, Func0<Double> valueCallback, Registry registry) {
        this.metricId = metricId;
        this.spectatorId = metricId.getSpectatorId(registry);
        ((PolledMeter.Builder)PolledMeter.using((Registry)registry).withId(this.spectatorId)).monitorValue((Object)this, GaugeCallback::doubleValue);
        this.valueCallback = valueCallback;
    }

    public GaugeCallback(String metricGroup, String metricName, Func0<Double> valueCallback, Registry registry, Iterable<Tag> tags) {
        this(new MetricId(metricGroup, metricName, tags), valueCallback, registry);
    }

    public GaugeCallback(String metricGroup, String metricName, Func0<Double> valueCallback, Registry registry, Tag ... tags) {
        this(new MetricId(metricGroup, metricName, tags), valueCallback, registry);
    }

    public GaugeCallback(String metricGroup, String metricName, Func0<Double> valueCallback, Tag ... tags) {
        this(new MetricId(metricGroup, metricName, tags), valueCallback, SpectatorRegistryFactory.getRegistry());
    }

    public GaugeCallback(MetricGroupId metricGroup, String metricName, Func0<Double> valueCallback) {
        this(new MetricId(metricGroup.name(), metricName, metricGroup.tags()), valueCallback, SpectatorRegistryFactory.getRegistry());
    }

    @Override
    public MetricId id() {
        return this.metricId;
    }

    @Override
    public String event() {
        return this.spectatorId.toString();
    }

    @Override
    public long value() {
        return this.valueCallback.call().longValue();
    }

    @Override
    public double doubleValue() {
        return this.valueCallback.call();
    }

    @Override
    public void increment() {
    }

    @Override
    public void decrement() {
    }

    @Override
    public void set(double value) {
    }

    @Override
    public void increment(double value) {
    }

    @Override
    public void decrement(double value) {
    }

    @Override
    public void set(long value) {
    }

    @Override
    public void increment(long value) {
    }

    @Override
    public void decrement(long value) {
    }
}

