/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.common.metrics.netty;

import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Tag;
import io.mantisrx.common.metrics.Counter;
import io.mantisrx.common.metrics.Gauge;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.MetricsRegistry;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import mantis.io.reactivex.netty.client.ClientMetricsEvent;
import mantis.io.reactivex.netty.metrics.ClientMetricEventsListener;

public class TcpClientListener<T extends ClientMetricsEvent<?>>
extends ClientMetricEventsListener<T> {
    private final Gauge liveConnections;
    private final Counter connectionCount;
    private final Gauge pendingConnects;
    private final Counter failedConnects;
    private final Gauge pendingConnectionClose;
    private final Counter failedConnectionClose;
    private final Gauge pendingPoolAcquires;
    private final Counter failedPoolAcquires;
    private final Gauge pendingPoolReleases;
    private final Counter failedPoolReleases;
    private final Counter poolAcquires;
    private final Counter poolEvictions;
    private final Counter poolReuse;
    private final Counter poolReleases;
    private final Gauge pendingWrites;
    private final Gauge pendingFlushes;
    private final Counter bytesWritten;
    private final Counter bytesRead;
    private final Counter failedWrites;
    private final Counter failedFlushes;
    private final String monitorId;

    protected TcpClientListener(String monitorId) {
        this.monitorId = monitorId;
        String idValue = Optional.ofNullable(monitorId).orElse("none");
        BasicTag idTag = new BasicTag("groupId", idValue);
        Metrics m = new Metrics.Builder().id("tcpClient", new Tag[]{idTag}).addGauge("liveConnections").addCounter("connectionCount").addGauge("pendingConnects").addCounter("failedConnects").addGauge("pendingConnectionClose").addCounter("failedConnectionClose").addGauge("pendingPoolAcquires").addCounter("failedPoolAcquires").addGauge("pendingPoolReleases").addCounter("failedPoolReleases").addCounter("poolAcquires").addCounter("poolEvictions").addCounter("poolReuse").addCounter("poolReleases").addGauge("pendingWrites").addGauge("pendingFlushes").addCounter("bytesWritten").addCounter("bytesRead").addCounter("failedWrites").addCounter("failedFlushes").build();
        m = MetricsRegistry.getInstance().registerAndGet(m);
        this.liveConnections = m.getGauge("liveConnections");
        this.connectionCount = m.getCounter("connectionCount");
        this.pendingConnects = m.getGauge("pendingConnects");
        this.failedConnects = m.getCounter("failedConnects");
        this.pendingConnectionClose = m.getGauge("pendingConnectionClose");
        this.failedConnectionClose = m.getCounter("failedConnectionClose");
        this.pendingPoolAcquires = m.getGauge("pendingPoolAcquires");
        this.failedPoolAcquires = m.getCounter("failedPoolAcquires");
        this.pendingPoolReleases = m.getGauge("pendingPoolReleases");
        this.failedPoolReleases = m.getCounter("failedPoolReleases");
        this.poolAcquires = m.getCounter("poolAcquires");
        this.poolEvictions = m.getCounter("poolEvictions");
        this.poolReuse = m.getCounter("poolReuse");
        this.poolReleases = m.getCounter("poolReleases");
        this.pendingWrites = m.getGauge("pendingWrites");
        this.pendingFlushes = m.getGauge("pendingFlushes");
        this.bytesWritten = m.getCounter("bytesWritten");
        this.bytesRead = m.getCounter("bytesRead");
        this.failedWrites = m.getCounter("failedWrites");
        this.failedFlushes = m.getCounter("failedFlushes");
    }

    public static TcpClientListener<ClientMetricsEvent<ClientMetricsEvent.EventType>> newListener(String monitorId) {
        return new TcpClientListener<ClientMetricsEvent<ClientMetricsEvent.EventType>>(monitorId);
    }

    @Override
    protected void onByteRead(long bytesRead) {
        this.bytesRead.increment(bytesRead);
    }

    @Override
    protected void onFlushFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.pendingFlushes.decrement();
        this.failedFlushes.increment();
    }

    @Override
    protected void onFlushSuccess(long duration, TimeUnit timeUnit) {
        this.pendingFlushes.decrement();
    }

    @Override
    protected void onFlushStart() {
        this.pendingFlushes.increment();
    }

    @Override
    protected void onWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.pendingWrites.decrement();
        this.failedWrites.increment();
    }

    @Override
    protected void onWriteSuccess(long duration, TimeUnit timeUnit, long bytesWritten) {
        this.pendingWrites.decrement();
        this.bytesWritten.increment(bytesWritten);
    }

    @Override
    protected void onWriteStart() {
        this.pendingWrites.increment();
    }

    @Override
    protected void onPoolReleaseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.pendingPoolReleases.decrement();
        this.poolReleases.increment();
        this.failedPoolReleases.increment();
    }

    @Override
    protected void onPoolReleaseSuccess(long duration, TimeUnit timeUnit) {
        this.pendingPoolReleases.decrement();
        this.poolReleases.increment();
    }

    @Override
    protected void onPoolReleaseStart() {
        this.pendingPoolReleases.increment();
    }

    @Override
    protected void onPooledConnectionEviction() {
        this.poolEvictions.increment();
    }

    @Override
    protected void onPooledConnectionReuse(long duration, TimeUnit timeUnit) {
        this.poolReuse.increment();
    }

    @Override
    protected void onPoolAcquireFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.pendingPoolAcquires.decrement();
        this.poolAcquires.increment();
        this.failedPoolAcquires.increment();
    }

    @Override
    protected void onPoolAcquireSuccess(long duration, TimeUnit timeUnit) {
        this.pendingPoolAcquires.decrement();
        this.poolAcquires.increment();
    }

    @Override
    protected void onPoolAcquireStart() {
        this.pendingPoolAcquires.increment();
    }

    @Override
    protected void onConnectionCloseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.liveConnections.decrement();
        this.pendingConnectionClose.decrement();
        this.failedConnectionClose.increment();
    }

    @Override
    protected void onConnectionCloseSuccess(long duration, TimeUnit timeUnit) {
        this.liveConnections.decrement();
        this.pendingConnectionClose.decrement();
    }

    @Override
    protected void onConnectionCloseStart() {
        this.pendingConnectionClose.increment();
    }

    @Override
    protected void onConnectFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.pendingConnects.decrement();
        this.failedConnects.increment();
    }

    @Override
    protected void onConnectSuccess(long duration, TimeUnit timeUnit) {
        this.pendingConnects.decrement();
        this.liveConnections.increment();
        this.connectionCount.increment();
    }

    @Override
    protected void onConnectStart() {
        this.pendingConnects.increment();
    }

    @Override
    public void onCompleted() {
    }

    @Override
    public void onSubscribe() {
    }
}

