/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.common.metrics.netty;

import io.mantisrx.common.metrics.netty.HttpClientListener;
import io.mantisrx.common.metrics.netty.HttpServerListener;
import io.mantisrx.common.metrics.netty.TcpClientListener;
import io.mantisrx.common.metrics.netty.TcpServerListener;
import io.mantisrx.common.metrics.netty.UdpClientListener;
import io.mantisrx.common.metrics.netty.UdpServerListener;
import mantis.io.reactivex.netty.client.ClientMetricsEvent;
import mantis.io.reactivex.netty.client.RxClient;
import mantis.io.reactivex.netty.metrics.MetricEventsListener;
import mantis.io.reactivex.netty.metrics.MetricEventsListenerFactory;
import mantis.io.reactivex.netty.protocol.http.client.HttpClient;
import mantis.io.reactivex.netty.protocol.http.server.HttpServer;
import mantis.io.reactivex.netty.protocol.http.websocket.WebSocketClient;
import mantis.io.reactivex.netty.protocol.http.websocket.WebSocketServer;
import mantis.io.reactivex.netty.protocol.udp.client.UdpClient;
import mantis.io.reactivex.netty.protocol.udp.server.UdpServer;
import mantis.io.reactivex.netty.server.RxServer;
import mantis.io.reactivex.netty.server.ServerMetricsEvent;

public class MantisNettyEventsListenerFactory
extends MetricEventsListenerFactory {
    private final String clientMetricNamePrefix;
    private final String serverMetricNamePrefix;

    public MantisNettyEventsListenerFactory() {
        this("mantis-rxnetty-client-", "mantis-rxnetty-server-");
    }

    public MantisNettyEventsListenerFactory(String clientMetricNamePrefix, String serverMetricNamePrefix) {
        this.clientMetricNamePrefix = clientMetricNamePrefix;
        this.serverMetricNamePrefix = serverMetricNamePrefix;
    }

    public TcpClientListener<ClientMetricsEvent<ClientMetricsEvent.EventType>> forTcpClient(RxClient client) {
        return TcpClientListener.newListener(this.clientMetricNamePrefix + client.name());
    }

    public HttpClientListener forHttpClient(HttpClient client) {
        return HttpClientListener.newHttpListener(this.clientMetricNamePrefix + client.name());
    }

    public UdpClientListener forUdpClient(UdpClient client) {
        return UdpClientListener.newUdpListener(this.clientMetricNamePrefix + client.name());
    }

    public TcpServerListener<ServerMetricsEvent<ServerMetricsEvent.EventType>> forTcpServer(RxServer server2) {
        return TcpServerListener.newListener(this.serverMetricNamePrefix + server2.getServerPort());
    }

    public HttpServerListener forHttpServer(HttpServer server2) {
        return HttpServerListener.newHttpListener(this.serverMetricNamePrefix + server2.getServerPort());
    }

    public UdpServerListener forUdpServer(UdpServer server2) {
        return UdpServerListener.newUdpListener(this.serverMetricNamePrefix + server2.getServerPort());
    }

    @Override
    public MetricEventsListener<ClientMetricsEvent<?>> forWebSocketClient(WebSocketClient client) {
        return null;
    }

    @Override
    public MetricEventsListener<ServerMetricsEvent<?>> forWebSocketServer(WebSocketServer server2) {
        return null;
    }
}

