/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.common;

import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import io.mantisrx.shaded.com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class WorkerPorts
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int metricsPort;
    private final int debugPort;
    private final int consolePort;
    private final int customPort;
    private final int sinkPort;
    private final List<Integer> ports;

    public WorkerPorts(List<Integer> assignedPorts) {
        if (assignedPorts.size() < 5) {
            throw new IllegalArgumentException("assignedPorts should have at least 5 ports");
        }
        this.metricsPort = assignedPorts.get(0);
        this.debugPort = assignedPorts.get(1);
        this.consolePort = assignedPorts.get(2);
        this.customPort = assignedPorts.get(3);
        this.sinkPort = assignedPorts.get(4);
        this.ports = ImmutableList.of(assignedPorts.get(4));
        if (!this.isValid()) {
            throw new IllegalStateException("worker validation failed on port allocation");
        }
    }

    public WorkerPorts(int metricsPort, int debugPort, int consolePort, int customPort, int sinkPort) {
        this(ImmutableList.of(Integer.valueOf(metricsPort), Integer.valueOf(debugPort), Integer.valueOf(consolePort), Integer.valueOf(customPort), Integer.valueOf(sinkPort)));
    }

    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public WorkerPorts(@JsonProperty(value="metricsPort") int metricsPort, @JsonProperty(value="debugPort") int debugPort, @JsonProperty(value="consolePort") int consolePort, @JsonProperty(value="customPort") int customPort, @JsonProperty(value="ports") List<Integer> ports) {
        this((List<Integer>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add((Object)metricsPort)).add((Object)debugPort)).add((Object)consolePort)).add((Object)customPort)).addAll(ports)).build()));
    }

    public int getMetricsPort() {
        return this.metricsPort;
    }

    public int getDebugPort() {
        return this.debugPort;
    }

    public int getConsolePort() {
        return this.consolePort;
    }

    public int getCustomPort() {
        return this.customPort;
    }

    public int getSinkPort() {
        return this.sinkPort;
    }

    public List<Integer> getPorts() {
        return this.ports;
    }

    @JsonIgnore
    public List<Integer> getAllPorts() {
        ArrayList<Integer> allPorts = new ArrayList<Integer>(this.ports);
        allPorts.add(this.metricsPort);
        allPorts.add(this.debugPort);
        allPorts.add(this.consolePort);
        allPorts.add(this.customPort);
        return allPorts;
    }

    private boolean isValid() {
        HashSet<Integer> uniquePorts = new HashSet<Integer>();
        uniquePorts.add(this.metricsPort);
        uniquePorts.add(this.consolePort);
        uniquePorts.add(this.debugPort);
        uniquePorts.add(this.customPort);
        uniquePorts.add(this.sinkPort);
        return uniquePorts.size() >= 5 && this.isValidPort(this.metricsPort) && this.isValidPort(this.consolePort) && this.isValidPort(this.debugPort) && this.isValidPort(this.customPort) && this.isValidPort(this.sinkPort);
    }

    @JsonIgnore
    public int getNumberOfPorts() {
        return this.ports.size();
    }

    private boolean isValidPort(int port) {
        return port > 0 && port <= 65535;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkerPorts)) {
            return false;
        }
        WorkerPorts other = (WorkerPorts)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMetricsPort() != other.getMetricsPort()) {
            return false;
        }
        if (this.getDebugPort() != other.getDebugPort()) {
            return false;
        }
        if (this.getConsolePort() != other.getConsolePort()) {
            return false;
        }
        if (this.getCustomPort() != other.getCustomPort()) {
            return false;
        }
        if (this.getSinkPort() != other.getSinkPort()) {
            return false;
        }
        List<Integer> this$ports = this.getPorts();
        List<Integer> other$ports = other.getPorts();
        return !(this$ports == null ? other$ports != null : !((Object)this$ports).equals(other$ports));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WorkerPorts;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMetricsPort();
        result = result * 59 + this.getDebugPort();
        result = result * 59 + this.getConsolePort();
        result = result * 59 + this.getCustomPort();
        result = result * 59 + this.getSinkPort();
        List<Integer> $ports = this.getPorts();
        result = result * 59 + ($ports == null ? 43 : ((Object)$ports).hashCode());
        return result;
    }

    public String toString() {
        return "WorkerPorts(metricsPort=" + this.getMetricsPort() + ", debugPort=" + this.getDebugPort() + ", consolePort=" + this.getConsolePort() + ", customPort=" + this.getCustomPort() + ", sinkPort=" + this.getSinkPort() + ", ports=" + this.getPorts() + ")";
    }
}

