/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.codec;

import io.reactivex.netty.codec.Codec;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

@Deprecated
public class Codecs {
    public static Codec<Integer> integer() {
        return new Codec<Integer>(){

            @Override
            public Integer decode(byte[] bytes2) {
                return ByteBuffer.wrap(bytes2).getInt();
            }

            @Override
            public byte[] encode(Integer value) {
                return ByteBuffer.allocate(4).putInt(value).array();
            }
        };
    }

    private static Codec<String> stringWithEncoding(String encoding2) {
        final Charset charset = Charset.forName(encoding2);
        return new Codec<String>(){

            @Override
            public String decode(byte[] bytes2) {
                return new String(bytes2, charset);
            }

            @Override
            public byte[] encode(String value) {
                return value.getBytes(charset);
            }
        };
    }

    public static Codec<String> stringAscii() {
        final Charset charset = Charset.forName("US-ASCII");
        return new Codec<String>(){

            @Override
            public String decode(byte[] bytes2) {
                return new String(bytes2, charset);
            }

            @Override
            public byte[] encode(String value) {
                byte[] bytes2 = new byte[value.length()];
                for (int i = 0; i < value.length(); ++i) {
                    bytes2[i] = (byte)value.charAt(i);
                }
                return bytes2;
            }
        };
    }

    public static Codec<String> stringUtf8() {
        return Codecs.stringWithEncoding("UTF-8");
    }

    public static Codec<String> string() {
        return Codecs.stringUtf8();
    }

    public static Codec<byte[]> bytearray() {
        return new Codec<byte[]>(){

            @Override
            public byte[] decode(byte[] bytes2) {
                return bytes2;
            }

            @Override
            public byte[] encode(byte[] value) {
                return value;
            }
        };
    }
}

