/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.Constant;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class ConstantPool<T extends Constant<T>> {
    private final ConcurrentMap<String, T> constants = PlatformDependent.newConcurrentHashMap();
    private final AtomicInteger nextId = new AtomicInteger(1);

    public T valueOf(Class<?> firstNameComponent, String secondNameComponent) {
        if (firstNameComponent == null) {
            throw new NullPointerException("firstNameComponent");
        }
        if (secondNameComponent == null) {
            throw new NullPointerException("secondNameComponent");
        }
        return this.valueOf(firstNameComponent.getName() + '#' + secondNameComponent);
    }

    public T valueOf(String name2) {
        ConstantPool.checkNotNullAndNotEmpty(name2);
        return this.getOrCreate(name2);
    }

    private T getOrCreate(String name2) {
        T tempConstant;
        Constant constant = (Constant)this.constants.get(name2);
        if (constant == null && (constant = (Constant)this.constants.putIfAbsent(name2, tempConstant = this.newConstant(this.nextId(), name2))) == null) {
            return tempConstant;
        }
        return (T)constant;
    }

    public boolean exists(String name2) {
        ConstantPool.checkNotNullAndNotEmpty(name2);
        return this.constants.containsKey(name2);
    }

    public T newInstance(String name2) {
        ConstantPool.checkNotNullAndNotEmpty(name2);
        return this.createOrThrow(name2);
    }

    private T createOrThrow(String name2) {
        T tempConstant;
        Constant constant = (Constant)this.constants.get(name2);
        if (constant == null && (constant = (Constant)this.constants.putIfAbsent(name2, tempConstant = this.newConstant(this.nextId(), name2))) == null) {
            return tempConstant;
        }
        throw new IllegalArgumentException(String.format("'%s' is already in use", name2));
    }

    private static String checkNotNullAndNotEmpty(String name2) {
        ObjectUtil.checkNotNull(name2, "name");
        if (name2.isEmpty()) {
            throw new IllegalArgumentException("empty name");
        }
        return name2;
    }

    protected abstract T newConstant(int var1, String var2);

    @Deprecated
    public final int nextId() {
        return this.nextId.getAndIncrement();
    }
}

