/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper;

import io.mantisrx.shaded.org.apache.zookeeper.AsyncCallback;
import io.mantisrx.shaded.org.apache.zookeeper.CreateMode;
import io.mantisrx.shaded.org.apache.zookeeper.KeeperException;
import io.mantisrx.shaded.org.apache.zookeeper.StatsTrack;
import io.mantisrx.shaded.org.apache.zookeeper.WatchedEvent;
import io.mantisrx.shaded.org.apache.zookeeper.Watcher;
import io.mantisrx.shaded.org.apache.zookeeper.ZKUtil;
import io.mantisrx.shaded.org.apache.zookeeper.ZooDefs;
import io.mantisrx.shaded.org.apache.zookeeper.ZooKeeper;
import io.mantisrx.shaded.org.apache.zookeeper.data.ACL;
import io.mantisrx.shaded.org.apache.zookeeper.data.Id;
import io.mantisrx.shaded.org.apache.zookeeper.data.Stat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class ZooKeeperMain {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperMain.class);
    static final Map<String, String> commandMap = new HashMap<String, String>();
    protected MyCommandOptions cl = new MyCommandOptions();
    protected HashMap<Integer, String> history = new HashMap();
    protected int commandCount = 0;
    protected boolean printWatches = true;
    protected ZooKeeper zk;
    protected String host = "";
    private static AsyncCallback.DataCallback dataCallback;

    public boolean getPrintWatches() {
        return this.printWatches;
    }

    static void usage() {
        System.err.println("ZooKeeper -server host:port cmd args");
        for (Map.Entry<String, String> entry : commandMap.entrySet()) {
            System.err.println("\t" + entry.getKey() + " " + entry.getValue());
        }
    }

    private static int getPermFromString(String permString) {
        int perm = 0;
        block7: for (int i = 0; i < permString.length(); ++i) {
            switch (permString.charAt(i)) {
                case 'r': {
                    perm |= 1;
                    continue block7;
                }
                case 'w': {
                    perm |= 2;
                    continue block7;
                }
                case 'c': {
                    perm |= 4;
                    continue block7;
                }
                case 'd': {
                    perm |= 8;
                    continue block7;
                }
                case 'a': {
                    perm |= 0x10;
                    continue block7;
                }
                default: {
                    System.err.println("Unknown perm type: " + permString.charAt(i));
                }
            }
        }
        return perm;
    }

    private static void printStat(Stat stat) {
        System.err.println("cZxid = 0x" + Long.toHexString(stat.getCzxid()));
        System.err.println("ctime = " + new Date(stat.getCtime()).toString());
        System.err.println("mZxid = 0x" + Long.toHexString(stat.getMzxid()));
        System.err.println("mtime = " + new Date(stat.getMtime()).toString());
        System.err.println("pZxid = 0x" + Long.toHexString(stat.getPzxid()));
        System.err.println("cversion = " + stat.getCversion());
        System.err.println("dataVersion = " + stat.getVersion());
        System.err.println("aclVersion = " + stat.getAversion());
        System.err.println("ephemeralOwner = 0x" + Long.toHexString(stat.getEphemeralOwner()));
        System.err.println("dataLength = " + stat.getDataLength());
        System.err.println("numChildren = " + stat.getNumChildren());
    }

    protected void addToHistory(int i, String cmd) {
        this.history.put(i, cmd);
    }

    public static List<String> getCommands() {
        return new LinkedList<String>(commandMap.keySet());
    }

    protected String getPrompt() {
        return "[zk: " + this.host + "(" + (Object)((Object)this.zk.getState()) + ") " + this.commandCount + "] ";
    }

    public static void printMessage(String msg) {
        System.out.println("\n" + msg);
    }

    protected void connectToZK(String newHost) throws InterruptedException, IOException {
        if (this.zk != null && this.zk.getState().isAlive()) {
            this.zk.close();
        }
        this.host = newHost;
        boolean readOnly = this.cl.getOption("readonly") != null;
        this.zk = new ZooKeeper(this.host, Integer.parseInt(this.cl.getOption("timeout")), new MyWatcher(), readOnly);
    }

    public static void main(String[] args) throws KeeperException, IOException, InterruptedException {
        ZooKeeperMain main2 = new ZooKeeperMain(args);
        main2.run();
    }

    public ZooKeeperMain(String[] args) throws IOException, InterruptedException {
        this.cl.parseOptions(args);
        System.out.println("Connecting to " + this.cl.getOption("server"));
        this.connectToZK(this.cl.getOption("server"));
    }

    public ZooKeeperMain(ZooKeeper zk) {
        this.zk = zk;
    }

    void run() throws KeeperException, IOException, InterruptedException {
        if (this.cl.getCommand() == null) {
            System.out.println("Welcome to ZooKeeper!");
            boolean jlinemissing = false;
            try {
                String line;
                Class<?> consoleC = Class.forName("io.mantisrx.shaded.jline.ConsoleReader");
                Class<?> completorC = Class.forName("io.mantisrx.shaded.org.apache.zookeeper.JLineZNodeCompletor");
                System.out.println("JLine support is enabled");
                Object console = consoleC.getConstructor(new Class[0]).newInstance(new Object[0]);
                Object completor = completorC.getConstructor(ZooKeeper.class).newInstance(this.zk);
                Method addCompletor = consoleC.getMethod("addCompletor", Class.forName("io.mantisrx.shaded.jline.Completor"));
                addCompletor.invoke(console, completor);
                Method readLine = consoleC.getMethod("readLine", String.class);
                while ((line = (String)readLine.invoke(console, this.getPrompt())) != null) {
                    this.executeLine(line);
                }
            }
            catch (ClassNotFoundException e2) {
                LOG.debug("Unable to start jline", e2);
                jlinemissing = true;
            }
            catch (NoSuchMethodException e3) {
                LOG.debug("Unable to start jline", e3);
                jlinemissing = true;
            }
            catch (InvocationTargetException e4) {
                LOG.debug("Unable to start jline", e4);
                jlinemissing = true;
            }
            catch (IllegalAccessException e5) {
                LOG.debug("Unable to start jline", e5);
                jlinemissing = true;
            }
            catch (InstantiationException e6) {
                LOG.debug("Unable to start jline", e6);
                jlinemissing = true;
            }
            if (jlinemissing) {
                String line;
                System.out.println("JLine support is disabled");
                BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                while ((line = br.readLine()) != null) {
                    this.executeLine(line);
                }
            }
        } else {
            this.processCmd(this.cl);
        }
    }

    public void executeLine(String line) throws InterruptedException, IOException, KeeperException {
        if (!line.equals("")) {
            this.cl.parseCommand(line);
            this.addToHistory(this.commandCount, line);
            this.processCmd(this.cl);
            ++this.commandCount;
        }
    }

    private static boolean trimProcQuotas(ZooKeeper zk, String path2) throws KeeperException, IOException, InterruptedException {
        if ("/zookeeper/quota".equals(path2)) {
            return true;
        }
        List<String> children2 = zk.getChildren(path2, false);
        if (children2.size() == 0) {
            zk.delete(path2, -1);
            String parent = path2.substring(0, path2.lastIndexOf(47));
            return ZooKeeperMain.trimProcQuotas(zk, parent);
        }
        return true;
    }

    public static boolean delQuota(ZooKeeper zk, String path2, boolean bytes2, boolean numNodes) throws KeeperException, IOException, InterruptedException {
        String parentPath = "/zookeeper/quota" + path2;
        String quotaPath = "/zookeeper/quota" + path2 + "/" + "zookeeper_limits";
        if (zk.exists(quotaPath, false) == null) {
            System.out.println("Quota does not exist for " + path2);
            return true;
        }
        byte[] data2 = null;
        try {
            data2 = zk.getData(quotaPath, false, new Stat());
        }
        catch (KeeperException.NoNodeException ne) {
            System.err.println("quota does not exist for " + path2);
            return true;
        }
        StatsTrack strack = new StatsTrack(new String(data2));
        if (bytes2 && !numNodes) {
            strack.setBytes(-1L);
            zk.setData(quotaPath, strack.toString().getBytes(), -1);
        } else if (!bytes2 && numNodes) {
            strack.setCount(-1);
            zk.setData(quotaPath, strack.toString().getBytes(), -1);
        } else if (bytes2 && numNodes) {
            List<String> children2 = zk.getChildren(parentPath, false);
            for (String child : children2) {
                zk.delete(parentPath + "/" + child, -1);
            }
            ZooKeeperMain.trimProcQuotas(zk, parentPath);
        }
        return true;
    }

    private static void checkIfParentQuota(ZooKeeper zk, String path2) throws InterruptedException, KeeperException {
        String[] splits = path2.split("/");
        String quotaPath = "/zookeeper/quota";
        for (String str2 : splits) {
            if (str2.length() == 0) continue;
            quotaPath = quotaPath + "/" + str2;
            List<String> children2 = null;
            try {
                children2 = zk.getChildren(quotaPath, false);
            }
            catch (KeeperException.NoNodeException ne) {
                LOG.debug("child removed during quota check", ne);
                return;
            }
            if (children2.size() == 0) {
                return;
            }
            for (String child : children2) {
                if (!"zookeeper_limits".equals(child)) continue;
                throw new IllegalArgumentException(path2 + " has a parent " + quotaPath + " which has a quota");
            }
        }
    }

    public static boolean createQuota(ZooKeeper zk, String path2, long bytes2, int numNodes) throws KeeperException, IOException, InterruptedException {
        Stat initStat = zk.exists(path2, false);
        if (initStat == null) {
            throw new IllegalArgumentException(path2 + " does not exist.");
        }
        String quotaPath = "/zookeeper/quota";
        String realPath = "/zookeeper/quota" + path2;
        try {
            List<String> children2 = zk.getChildren(realPath, false);
            for (String child : children2) {
                if (child.startsWith("zookeeper_")) continue;
                throw new IllegalArgumentException(path2 + " has child " + child + " which has a quota");
            }
        }
        catch (KeeperException.NoNodeException children2) {
            // empty catch block
        }
        ZooKeeperMain.checkIfParentQuota(zk, path2);
        if (zk.exists(quotaPath, false) == null) {
            try {
                zk.create("/zookeeper", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                zk.create("/zookeeper/quota", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            catch (KeeperException.NodeExistsException children2) {
                // empty catch block
            }
        }
        String[] splits = path2.split("/");
        StringBuilder sb = new StringBuilder();
        sb.append(quotaPath);
        for (int i = 1; i < splits.length; ++i) {
            sb.append("/" + splits[i]);
            quotaPath = sb.toString();
            try {
                zk.create(quotaPath, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                continue;
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                // empty catch block
            }
        }
        String statPath = quotaPath + "/" + "zookeeper_stats";
        quotaPath = quotaPath + "/" + "zookeeper_limits";
        StatsTrack strack = new StatsTrack(null);
        strack.setBytes(bytes2);
        strack.setCount(numNodes);
        try {
            zk.create(quotaPath, strack.toString().getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            StatsTrack stats = new StatsTrack(null);
            stats.setBytes(0L);
            stats.setCount(0);
            zk.create(statPath, stats.toString().getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException ne) {
            byte[] data2 = zk.getData(quotaPath, false, new Stat());
            StatsTrack strackC = new StatsTrack(new String(data2));
            if (bytes2 != -1L) {
                strackC.setBytes(bytes2);
            }
            if (numNodes != -1) {
                strackC.setCount(numNodes);
            }
            zk.setData(quotaPath, strackC.toString().getBytes(), -1);
        }
        return true;
    }

    protected boolean processCmd(MyCommandOptions co) throws KeeperException, IOException, InterruptedException {
        try {
            return this.processZKCmd(co);
        }
        catch (IllegalArgumentException e2) {
            System.err.println("Command failed: " + e2);
        }
        catch (KeeperException.NoNodeException e3) {
            System.err.println("Node does not exist: " + e3.getPath());
        }
        catch (KeeperException.NoChildrenForEphemeralsException e4) {
            System.err.println("Ephemerals cannot have children: " + e4.getPath());
        }
        catch (KeeperException.NodeExistsException e5) {
            System.err.println("Node already exists: " + e5.getPath());
        }
        catch (KeeperException.NotEmptyException e6) {
            System.err.println("Node not empty: " + e6.getPath());
        }
        catch (KeeperException.NotReadOnlyException e7) {
            System.err.println("Not a read-only call: " + e7.getPath());
        }
        catch (KeeperException.InvalidACLException e8) {
            System.err.println("Acl is not valid : " + e8.getPath());
        }
        catch (KeeperException.NoAuthException e9) {
            System.err.println("Authentication is not valid : " + e9.getPath());
        }
        catch (KeeperException.BadArgumentsException e10) {
            System.err.println("Arguments are not valid : " + e10.getPath());
        }
        catch (KeeperException.BadVersionException e11) {
            System.err.println("version No is not valid : " + e11.getPath());
        }
        return false;
    }

    protected boolean processZKCmd(MyCommandOptions co) throws KeeperException, IOException, InterruptedException {
        String option;
        Object children2;
        Stat stat = new Stat();
        String[] args = co.getArgArray();
        String cmd = co.getCommand();
        if (args.length < 1) {
            ZooKeeperMain.usage();
            return false;
        }
        if (!commandMap.containsKey(cmd)) {
            ZooKeeperMain.usage();
            return false;
        }
        boolean watch = args.length > 2;
        String path2 = null;
        List<ACL> acl = ZooDefs.Ids.OPEN_ACL_UNSAFE;
        LOG.debug("Processing " + cmd);
        if (cmd.equals("quit")) {
            System.out.println("Quitting...");
            this.zk.close();
            System.exit(0);
        } else if (cmd.equals("redo") && args.length >= 2) {
            Integer i = Integer.decode(args[1]);
            if (this.commandCount <= i || i < 0) {
                System.out.println("Command index out of range");
                return false;
            }
            this.cl.parseCommand(this.history.get(i));
            if (this.cl.getCommand().equals("redo")) {
                System.out.println("No redoing redos");
                return false;
            }
            this.history.put(this.commandCount, this.history.get(i));
            this.processCmd(this.cl);
        } else if (cmd.equals("history")) {
            for (int i = this.commandCount - 10; i <= this.commandCount; ++i) {
                if (i < 0) continue;
                System.out.println(i + " - " + this.history.get(i));
            }
        } else if (cmd.equals("printwatches")) {
            if (args.length == 1) {
                System.out.println("printwatches is " + (this.printWatches ? "on" : "off"));
            } else {
                this.printWatches = args[1].equals("on");
            }
        } else if (cmd.equals("connect")) {
            if (args.length >= 2) {
                this.connectToZK(args[1]);
            } else {
                this.connectToZK(this.host);
            }
        }
        if (this.zk == null || !this.zk.getState().isAlive()) {
            System.out.println("Not connected");
            return false;
        }
        if (cmd.equals("create") && args.length >= 3) {
            int first2 = 0;
            CreateMode flags = CreateMode.PERSISTENT;
            if (args[1].equals("-e") && args[2].equals("-s") || args[1].equals("-s") && args[2].equals("-e")) {
                first2 += 2;
                flags = CreateMode.EPHEMERAL_SEQUENTIAL;
            } else if (args[1].equals("-e")) {
                ++first2;
                flags = CreateMode.EPHEMERAL;
            } else if (args[1].equals("-s")) {
                ++first2;
                flags = CreateMode.PERSISTENT_SEQUENTIAL;
            }
            if (args.length == first2 + 4) {
                acl = ZooKeeperMain.parseACLs(args[first2 + 3]);
            }
            path2 = args[first2 + 1];
            String newPath = this.zk.create(path2, args[first2 + 2].getBytes(), acl, flags);
            System.err.println("Created " + newPath);
        } else if (cmd.equals("delete") && args.length >= 2) {
            path2 = args[1];
            this.zk.delete(path2, watch ? Integer.parseInt(args[2]) : -1);
        } else if (cmd.equals("rmr") && args.length >= 2) {
            path2 = args[1];
            ZKUtil.deleteRecursive(this.zk, path2);
        } else if (cmd.equals("set") && args.length >= 3) {
            path2 = args[1];
            stat = this.zk.setData(path2, args[2].getBytes(), args.length > 3 ? Integer.parseInt(args[3]) : -1);
            ZooKeeperMain.printStat(stat);
        } else if (cmd.equals("aget") && args.length >= 2) {
            path2 = args[1];
            this.zk.getData(path2, watch, dataCallback, (Object)path2);
        } else if (cmd.equals("get") && args.length >= 2) {
            path2 = args[1];
            byte[] data2 = this.zk.getData(path2, watch, stat);
            data2 = data2 == null ? "null".getBytes() : data2;
            System.out.println(new String(data2));
            ZooKeeperMain.printStat(stat);
        } else if (cmd.equals("ls") && args.length >= 2) {
            path2 = args[1];
            children2 = this.zk.getChildren(path2, watch);
            System.out.println(children2);
        } else if (cmd.equals("ls2") && args.length >= 2) {
            path2 = args[1];
            children2 = this.zk.getChildren(path2, watch, stat);
            System.out.println(children2);
            ZooKeeperMain.printStat(stat);
        } else if (cmd.equals("getAcl") && args.length >= 2) {
            path2 = args[1];
            acl = this.zk.getACL(path2, stat);
            for (ACL a : acl) {
                System.out.println(a.getId() + ": " + ZooKeeperMain.getPermString(a.getPerms()));
            }
        } else if (cmd.equals("setAcl") && args.length >= 3) {
            path2 = args[1];
            stat = this.zk.setACL(path2, ZooKeeperMain.parseACLs(args[2]), args.length > 4 ? Integer.parseInt(args[3]) : -1);
            ZooKeeperMain.printStat(stat);
        } else if (cmd.equals("stat") && args.length >= 2) {
            path2 = args[1];
            stat = this.zk.exists(path2, watch);
            if (stat == null) {
                throw new KeeperException.NoNodeException(path2);
            }
            ZooKeeperMain.printStat(stat);
        } else if (cmd.equals("listquota") && args.length >= 2) {
            path2 = args[1];
            String absolutePath = "/zookeeper/quota" + path2 + "/" + "zookeeper_limits";
            byte[] data3 = null;
            try {
                System.err.println("absolute path is " + absolutePath);
                data3 = this.zk.getData(absolutePath, false, stat);
                StatsTrack st = new StatsTrack(new String(data3));
                System.out.println("Output quota for " + path2 + " " + st.toString());
                data3 = this.zk.getData("/zookeeper/quota" + path2 + "/" + "zookeeper_stats", false, stat);
                System.out.println("Output stat for " + path2 + " " + new StatsTrack(new String(data3)).toString());
            }
            catch (KeeperException.NoNodeException ne) {
                System.err.println("quota for " + path2 + " does not exist.");
            }
        } else if (cmd.equals("setquota") && args.length >= 4) {
            option = args[1];
            String val2 = args[2];
            path2 = args[3];
            System.err.println("Comment: the parts are option " + option + " val " + val2 + " path " + path2);
            if ("-b".equals(option)) {
                ZooKeeperMain.createQuota(this.zk, path2, Long.parseLong(val2), -1);
            } else if ("-n".equals(option)) {
                ZooKeeperMain.createQuota(this.zk, path2, -1L, Integer.parseInt(val2));
            } else {
                ZooKeeperMain.usage();
            }
        } else if (cmd.equals("delquota") && args.length >= 2) {
            if (args.length == 3) {
                option = args[1];
                path2 = args[2];
                if ("-b".equals(option)) {
                    ZooKeeperMain.delQuota(this.zk, path2, true, false);
                } else if ("-n".equals(option)) {
                    ZooKeeperMain.delQuota(this.zk, path2, false, true);
                }
            } else if (args.length == 2) {
                path2 = args[1];
                ZooKeeperMain.delQuota(this.zk, path2, true, true);
            } else if (cmd.equals("help")) {
                ZooKeeperMain.usage();
            }
        } else if (cmd.equals("close")) {
            this.zk.close();
        } else if (cmd.equals("sync") && args.length >= 2) {
            path2 = args[1];
            this.zk.sync(path2, new AsyncCallback.VoidCallback(){

                @Override
                public void processResult(int rc, String path2, Object ctx) {
                    System.out.println("Sync returned " + rc);
                }
            }, null);
        } else if (cmd.equals("addauth") && args.length >= 2) {
            byte[] b = null;
            if (args.length >= 3) {
                b = args[2].getBytes();
            }
            this.zk.addAuthInfo(args[1], b);
        } else if (!commandMap.containsKey(cmd)) {
            ZooKeeperMain.usage();
        }
        return watch;
    }

    private static String getPermString(int perms) {
        StringBuilder p = new StringBuilder();
        if ((perms & 4) != 0) {
            p.append('c');
        }
        if ((perms & 8) != 0) {
            p.append('d');
        }
        if ((perms & 1) != 0) {
            p.append('r');
        }
        if ((perms & 2) != 0) {
            p.append('w');
        }
        if ((perms & 0x10) != 0) {
            p.append('a');
        }
        return p.toString();
    }

    private static List<ACL> parseACLs(String aclString) {
        String[] acls = aclString.split(",");
        ArrayList<ACL> acl = new ArrayList<ACL>();
        for (String a : acls) {
            int firstColon = a.indexOf(58);
            int lastColon = a.lastIndexOf(58);
            if (firstColon == -1 || lastColon == -1 || firstColon == lastColon) {
                System.err.println(a + " does not have the form scheme:id:perm");
                continue;
            }
            ACL newAcl = new ACL();
            newAcl.setId(new Id(a.substring(0, firstColon), a.substring(firstColon + 1, lastColon)));
            newAcl.setPerms(ZooKeeperMain.getPermFromString(a.substring(lastColon + 1)));
            acl.add(newAcl);
        }
        return acl;
    }

    static {
        commandMap.put("connect", "host:port");
        commandMap.put("close", "");
        commandMap.put("create", "[-s] [-e] path data acl");
        commandMap.put("delete", "path [version]");
        commandMap.put("rmr", "path");
        commandMap.put("set", "path data [version]");
        commandMap.put("get", "path [watch]");
        commandMap.put("ls", "path [watch]");
        commandMap.put("ls2", "path [watch]");
        commandMap.put("getAcl", "path");
        commandMap.put("setAcl", "path acl");
        commandMap.put("stat", "path [watch]");
        commandMap.put("sync", "path");
        commandMap.put("setquota", "-n|-b val path");
        commandMap.put("listquota", "path");
        commandMap.put("delquota", "[-n|-b] path");
        commandMap.put("history", "");
        commandMap.put("redo", "cmdno");
        commandMap.put("printwatches", "on|off");
        commandMap.put("quit", "");
        commandMap.put("addauth", "scheme auth");
        dataCallback = new AsyncCallback.DataCallback(){

            @Override
            public void processResult(int rc, String path2, Object ctx, byte[] data2, Stat stat) {
                System.out.println("rc = " + rc + " path = " + path2 + " data = " + (data2 == null ? "null" : new String(data2)) + " stat = ");
                ZooKeeperMain.printStat(stat);
            }
        };
    }

    static class MyCommandOptions {
        private Map<String, String> options = new HashMap<String, String>();
        private List<String> cmdArgs = null;
        private String command = null;
        public static final Pattern ARGS_PATTERN = Pattern.compile("\\s*([^\"']\\S*|\"[^\"]*\"|'[^']*')\\s*");
        public static final Pattern QUOTED_PATTERN = Pattern.compile("^(['\"])(.*)(\\1)$");

        public MyCommandOptions() {
            this.options.put("server", "localhost:2181");
            this.options.put("timeout", "30000");
        }

        public String getOption(String opt2) {
            return this.options.get(opt2);
        }

        public String getCommand() {
            return this.command;
        }

        public String getCmdArgument(int index2) {
            return this.cmdArgs.get(index2);
        }

        public int getNumArguments() {
            return this.cmdArgs.size();
        }

        public String[] getArgArray() {
            return this.cmdArgs.toArray(new String[0]);
        }

        public boolean parseOptions(String[] args) {
            List<String> argList = Arrays.asList(args);
            Iterator<String> it = argList.iterator();
            while (it.hasNext()) {
                String opt2 = it.next();
                try {
                    if (opt2.equals("-server")) {
                        this.options.put("server", it.next());
                    } else if (opt2.equals("-timeout")) {
                        this.options.put("timeout", it.next());
                    } else if (opt2.equals("-r")) {
                        this.options.put("readonly", "true");
                    }
                }
                catch (NoSuchElementException e2) {
                    System.err.println("Error: no argument found for option " + opt2);
                    return false;
                }
                if (opt2.startsWith("-")) continue;
                this.command = opt2;
                this.cmdArgs = new ArrayList<String>();
                this.cmdArgs.add(this.command);
                while (it.hasNext()) {
                    this.cmdArgs.add(it.next());
                }
                return true;
            }
            return true;
        }

        public boolean parseCommand(String cmdstring) {
            Matcher matcher = ARGS_PATTERN.matcher(cmdstring);
            LinkedList<String> args = new LinkedList<String>();
            while (matcher.find()) {
                String value = matcher.group(1);
                if (QUOTED_PATTERN.matcher(value).matches()) {
                    value = value.substring(1, value.length() - 1);
                }
                args.add(value);
            }
            if (args.isEmpty()) {
                return false;
            }
            this.command = (String)args.get(0);
            this.cmdArgs = args;
            return true;
        }
    }

    private class MyWatcher
    implements Watcher {
        private MyWatcher() {
        }

        @Override
        public void process(WatchedEvent event) {
            if (ZooKeeperMain.this.getPrintWatches()) {
                ZooKeeperMain.printMessage("WATCHER::");
                ZooKeeperMain.printMessage(event.toString());
            }
        }
    }
}

