/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.command;

import io.mantisrx.runtime.Job;
import io.mantisrx.runtime.SinkHolder;
import io.mantisrx.runtime.SourceHolder;
import io.mantisrx.runtime.StageConfig;
import io.mantisrx.runtime.command.Command;
import io.mantisrx.runtime.command.CommandException;
import io.mantisrx.runtime.command.InvalidJobException;
import java.util.List;

public class ValidateJob
implements Command {
    private Job job;

    public ValidateJob(Job job) {
        this.job = job;
    }

    @Override
    public void execute() throws CommandException {
        if (this.job == null) {
            throw new InvalidJobException("job reference cannot be null");
        }
        SourceHolder<?> source2 = this.job.getSource();
        if (source2 == null || source2.getSourceFunction() == null) {
            throw new InvalidJobException("A job requires a source");
        }
        List<StageConfig<?, ?>> stages = this.job.getStages();
        if (stages == null || stages.isEmpty()) {
            throw new InvalidJobException("A job requires at least one stage");
        }
        int i = 0;
        for (StageConfig<?, ?> stage : stages) {
            if (stage == null) {
                throw new InvalidJobException("Stage cannot be null, for stage number: " + i);
            }
            ++i;
        }
        SinkHolder sink = this.job.getSink();
        if (sink == null || sink.getSinkAction() == null) {
            throw new InvalidJobException("A job requires a sink");
        }
    }
}

