/*
 * Decompiled with CFR 0.152.
 */
package mantis.io.reactivex.netty.protocol.http.server.file;

import io.netty.buffer.ByteBuf;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedFile;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import mantis.io.reactivex.netty.protocol.http.server.HttpError;
import mantis.io.reactivex.netty.protocol.http.server.HttpServerRequest;
import mantis.io.reactivex.netty.protocol.http.server.HttpServerResponse;
import mantis.io.reactivex.netty.protocol.http.server.file.AbstractFileRequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public abstract class FileRequestHandler
extends AbstractFileRequestHandler {
    private static final Logger logger = LoggerFactory.getLogger(FileRequestHandler.class);
    private static final int CHUNK_SIZE = 8192;

    @Override
    public Observable<Void> handle(HttpServerRequest<ByteBuf> request, HttpServerResponse<ByteBuf> response) {
        long fileLength;
        if (!request.getHttpMethod().equals(HttpMethod.GET)) {
            return Observable.error(new HttpError(HttpResponseStatus.METHOD_NOT_ALLOWED));
        }
        RandomAccessFile raf = null;
        String sanitizedUri = FileRequestHandler.sanitizeUri(request.getUri());
        if (sanitizedUri == null) {
            return Observable.error(new HttpError(HttpResponseStatus.FORBIDDEN));
        }
        URI uri = this.resolveUri(sanitizedUri);
        if (uri == null) {
            return Observable.error(new HttpError(HttpResponseStatus.NOT_FOUND));
        }
        File file2 = new File(uri);
        if (file2.isHidden() || !file2.exists()) {
            return Observable.error(new HttpError(HttpResponseStatus.NOT_FOUND));
        }
        if (file2.isDirectory()) {
            return Observable.error(new HttpError(HttpResponseStatus.FORBIDDEN));
        }
        if (!file2.isFile()) {
            return Observable.error(new HttpError(HttpResponseStatus.FORBIDDEN));
        }
        try {
            raf = new RandomAccessFile(file2, "r");
            fileLength = raf.length();
        }
        catch (Exception e2) {
            logger.warn("Error accessing file {}", (Object)uri, (Object)e2);
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException e1) {
                    logger.warn("Error closing file {}", (Object)uri, (Object)e1);
                }
            }
            return Observable.error(e2);
        }
        String ifModifiedSince = request.getHeaders().get("If-Modified-Since");
        if (ifModifiedSince != null && !ifModifiedSince.isEmpty()) {
            long fileLastModifiedSeconds;
            long ifModifiedSinceDateSeconds;
            SimpleDateFormat dateFormatter = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
            Date ifModifiedSinceDate = null;
            try {
                ifModifiedSinceDate = dateFormatter.parse(ifModifiedSince);
            }
            catch (ParseException e3) {
                logger.warn("Failed to parse {} header", (Object)"If-Modified-Since");
            }
            if (ifModifiedSinceDate != null && (ifModifiedSinceDateSeconds = ifModifiedSinceDate.getTime() / 1000L) == (fileLastModifiedSeconds = file2.lastModified() / 1000L)) {
                response.setStatus(HttpResponseStatus.NOT_MODIFIED);
                FileRequestHandler.setDateHeader(response, dateFormatter);
                return response.close();
            }
        }
        response.setStatus(HttpResponseStatus.OK);
        response.getHeaders().setContentLength(fileLength);
        FileRequestHandler.setContentTypeHeader(response, file2);
        FileRequestHandler.setDateAndCacheHeaders(response, file2);
        if (request.getHeaders().isKeepAlive()) {
            response.getHeaders().set("Connection", (Object)"keep-alive");
        }
        if (response.getChannel().pipeline().get(SslHandler.class) == null) {
            response.writeFileRegion(new DefaultFileRegion(raf.getChannel(), 0L, fileLength));
        } else {
            try {
                response.writeChunkedInput(new HttpChunkedInput(new ChunkedFile(raf, 0L, fileLength, 8192)));
            }
            catch (IOException e4) {
                logger.warn("Failed to write chunked file {}", e4);
                return Observable.error(e4);
            }
        }
        return response.close();
    }

    protected abstract URI resolveUri(String var1);
}

