/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.com.google.common.collect;

import io.mantisrx.shaded.com.google.common.annotations.GwtCompatible;
import io.mantisrx.shaded.com.google.common.annotations.VisibleForTesting;
import io.mantisrx.shaded.com.google.common.base.Function;
import io.mantisrx.shaded.com.google.common.base.Preconditions;
import io.mantisrx.shaded.com.google.common.collect.AllEqualOrdering;
import io.mantisrx.shaded.com.google.common.collect.ByFunctionOrdering;
import io.mantisrx.shaded.com.google.common.collect.CollectPreconditions;
import io.mantisrx.shaded.com.google.common.collect.ComparatorOrdering;
import io.mantisrx.shaded.com.google.common.collect.CompoundOrdering;
import io.mantisrx.shaded.com.google.common.collect.ExplicitOrdering;
import io.mantisrx.shaded.com.google.common.collect.ImmutableList;
import io.mantisrx.shaded.com.google.common.collect.Iterables;
import io.mantisrx.shaded.com.google.common.collect.LexicographicalOrdering;
import io.mantisrx.shaded.com.google.common.collect.Lists;
import io.mantisrx.shaded.com.google.common.collect.MapMaker;
import io.mantisrx.shaded.com.google.common.collect.Maps;
import io.mantisrx.shaded.com.google.common.collect.NaturalOrdering;
import io.mantisrx.shaded.com.google.common.collect.NullsFirstOrdering;
import io.mantisrx.shaded.com.google.common.collect.NullsLastOrdering;
import io.mantisrx.shaded.com.google.common.collect.ObjectArrays;
import io.mantisrx.shaded.com.google.common.collect.Platform;
import io.mantisrx.shaded.com.google.common.collect.ReverseOrdering;
import io.mantisrx.shaded.com.google.common.collect.UsingToStringOrdering;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

@GwtCompatible
public abstract class Ordering<T>
implements Comparator<T> {
    static final int LEFT_IS_GREATER = 1;
    static final int RIGHT_IS_GREATER = -1;

    @GwtCompatible(serializable=true)
    public static <C extends Comparable> Ordering<C> natural() {
        return NaturalOrdering.INSTANCE;
    }

    @GwtCompatible(serializable=true)
    public static <T> Ordering<T> from(Comparator<T> comparator2) {
        return comparator2 instanceof Ordering ? (Ordering<T>)comparator2 : new ComparatorOrdering<T>(comparator2);
    }

    @Deprecated
    @GwtCompatible(serializable=true)
    public static <T> Ordering<T> from(Ordering<T> ordering) {
        return Preconditions.checkNotNull(ordering);
    }

    @GwtCompatible(serializable=true)
    public static <T> Ordering<T> explicit(List<T> valuesInOrder) {
        return new ExplicitOrdering<T>(valuesInOrder);
    }

    @GwtCompatible(serializable=true)
    public static <T> Ordering<T> explicit(T leastValue, T ... remainingValuesInOrder) {
        return Ordering.explicit(Lists.asList(leastValue, remainingValuesInOrder));
    }

    @GwtCompatible(serializable=true)
    public static Ordering<Object> allEqual() {
        return AllEqualOrdering.INSTANCE;
    }

    @GwtCompatible(serializable=true)
    public static Ordering<Object> usingToString() {
        return UsingToStringOrdering.INSTANCE;
    }

    public static Ordering<Object> arbitrary() {
        return ArbitraryOrderingHolder.ARBITRARY_ORDERING;
    }

    protected Ordering() {
    }

    @GwtCompatible(serializable=true)
    public <S extends T> Ordering<S> reverse() {
        return new ReverseOrdering(this);
    }

    @GwtCompatible(serializable=true)
    public <S extends T> Ordering<S> nullsFirst() {
        return new NullsFirstOrdering(this);
    }

    @GwtCompatible(serializable=true)
    public <S extends T> Ordering<S> nullsLast() {
        return new NullsLastOrdering(this);
    }

    @GwtCompatible(serializable=true)
    public <F> Ordering<F> onResultOf(Function<F, ? extends T> function) {
        return new ByFunctionOrdering<F, T>(function, this);
    }

    <T2 extends T> Ordering<Map.Entry<T2, ?>> onKeys() {
        return this.onResultOf(Maps.keyFunction());
    }

    @GwtCompatible(serializable=true)
    public <U extends T> Ordering<U> compound(Comparator<? super U> secondaryComparator) {
        return new CompoundOrdering<U>(this, Preconditions.checkNotNull(secondaryComparator));
    }

    @GwtCompatible(serializable=true)
    public static <T> Ordering<T> compound(Iterable<? extends Comparator<? super T>> comparators) {
        return new CompoundOrdering(comparators);
    }

    @GwtCompatible(serializable=true)
    public <S extends T> Ordering<Iterable<S>> lexicographical() {
        return new LexicographicalOrdering(this);
    }

    @Override
    public abstract int compare(@Nullable T var1, @Nullable T var2);

    public <E extends T> E min(Iterator<E> iterator) {
        E minSoFar = iterator.next();
        while (iterator.hasNext()) {
            minSoFar = this.min(minSoFar, iterator.next());
        }
        return minSoFar;
    }

    public <E extends T> E min(Iterable<E> iterable) {
        return this.min(iterable.iterator());
    }

    public <E extends T> E min(@Nullable E a, @Nullable E b) {
        return this.compare(a, b) <= 0 ? a : b;
    }

    public <E extends T> E min(@Nullable E a, @Nullable E b, @Nullable E c, E ... rest) {
        E minSoFar = this.min(this.min(a, b), c);
        for (E r : rest) {
            minSoFar = this.min(minSoFar, r);
        }
        return minSoFar;
    }

    public <E extends T> E max(Iterator<E> iterator) {
        E maxSoFar = iterator.next();
        while (iterator.hasNext()) {
            maxSoFar = this.max(maxSoFar, iterator.next());
        }
        return maxSoFar;
    }

    public <E extends T> E max(Iterable<E> iterable) {
        return this.max(iterable.iterator());
    }

    public <E extends T> E max(@Nullable E a, @Nullable E b) {
        return this.compare(a, b) >= 0 ? a : b;
    }

    public <E extends T> E max(@Nullable E a, @Nullable E b, @Nullable E c, E ... rest) {
        E maxSoFar = this.max(this.max(a, b), c);
        for (E r : rest) {
            maxSoFar = this.max(maxSoFar, r);
        }
        return maxSoFar;
    }

    public <E extends T> List<E> leastOf(Iterable<E> iterable, int k) {
        Collection collection;
        if (iterable instanceof Collection && (long)(collection = (Collection)iterable).size() <= 2L * (long)k) {
            Object[] array2 = collection.toArray();
            Arrays.sort(array2, this);
            if (array2.length > k) {
                array2 = ObjectArrays.arraysCopyOf(array2, k);
            }
            return Collections.unmodifiableList(Arrays.asList(array2));
        }
        return this.leastOf(iterable.iterator(), k);
    }

    public <E extends T> List<E> leastOf(Iterator<E> elements, int k) {
        E e2;
        Preconditions.checkNotNull(elements);
        CollectPreconditions.checkNonnegative(k, "k");
        if (k == 0 || !elements.hasNext()) {
            return ImmutableList.of();
        }
        if (k >= 0x3FFFFFFF) {
            ArrayList<E> list = Lists.newArrayList(elements);
            Collections.sort(list, this);
            if (list.size() > k) {
                list.subList(k, list.size()).clear();
            }
            list.trimToSize();
            return Collections.unmodifiableList(list);
        }
        int bufferCap = k * 2;
        Object[] buffer = new Object[bufferCap];
        Object threshold = elements.next();
        buffer[0] = threshold;
        int bufferSize = 1;
        while (bufferSize < k && elements.hasNext()) {
            e2 = elements.next();
            buffer[bufferSize++] = e2;
            threshold = this.max(threshold, e2);
        }
        while (elements.hasNext()) {
            e2 = elements.next();
            if (this.compare(e2, threshold) >= 0) continue;
            buffer[bufferSize++] = e2;
            if (bufferSize != bufferCap) continue;
            int left2 = 0;
            int right2 = bufferCap - 1;
            int minThresholdPosition = 0;
            while (left2 < right2) {
                int pivotIndex = left2 + right2 + 1 >>> 1;
                int pivotNewIndex = this.partition(buffer, left2, right2, pivotIndex);
                if (pivotNewIndex > k) {
                    right2 = pivotNewIndex - 1;
                    continue;
                }
                if (pivotNewIndex >= k) break;
                left2 = Math.max(pivotNewIndex, left2 + 1);
                minThresholdPosition = pivotNewIndex;
            }
            bufferSize = k;
            threshold = buffer[minThresholdPosition];
            for (int i = minThresholdPosition + 1; i < bufferSize; ++i) {
                threshold = this.max(threshold, buffer[i]);
            }
        }
        Arrays.sort(buffer, 0, bufferSize, this);
        bufferSize = Math.min(bufferSize, k);
        return Collections.unmodifiableList(Arrays.asList(ObjectArrays.arraysCopyOf(buffer, bufferSize)));
    }

    private <E extends T> int partition(E[] values, int left2, int right2, int pivotIndex) {
        E pivotValue = values[pivotIndex];
        values[pivotIndex] = values[right2];
        values[right2] = pivotValue;
        int storeIndex = left2;
        for (int i = left2; i < right2; ++i) {
            if (this.compare(values[i], pivotValue) >= 0) continue;
            ObjectArrays.swap(values, storeIndex, i);
            ++storeIndex;
        }
        ObjectArrays.swap(values, right2, storeIndex);
        return storeIndex;
    }

    public <E extends T> List<E> greatestOf(Iterable<E> iterable, int k) {
        return this.reverse().leastOf(iterable, k);
    }

    public <E extends T> List<E> greatestOf(Iterator<E> iterator, int k) {
        return this.reverse().leastOf(iterator, k);
    }

    public <E extends T> List<E> sortedCopy(Iterable<E> elements) {
        Object[] array2 = Iterables.toArray(elements);
        Arrays.sort(array2, this);
        return Lists.newArrayList(Arrays.asList(array2));
    }

    public <E extends T> ImmutableList<E> immutableSortedCopy(Iterable<E> elements) {
        Object[] array2;
        for (Object e2 : array2 = Iterables.toArray(elements)) {
            Preconditions.checkNotNull(e2);
        }
        Arrays.sort(array2, this);
        return ImmutableList.asImmutableList(array2);
    }

    public boolean isOrdered(Iterable<? extends T> iterable) {
        Iterator<T> it = iterable.iterator();
        if (it.hasNext()) {
            T prev2 = it.next();
            while (it.hasNext()) {
                T next2 = it.next();
                if (this.compare(prev2, next2) > 0) {
                    return false;
                }
                prev2 = next2;
            }
        }
        return true;
    }

    public boolean isStrictlyOrdered(Iterable<? extends T> iterable) {
        Iterator<T> it = iterable.iterator();
        if (it.hasNext()) {
            T prev2 = it.next();
            while (it.hasNext()) {
                T next2 = it.next();
                if (this.compare(prev2, next2) >= 0) {
                    return false;
                }
                prev2 = next2;
            }
        }
        return true;
    }

    public int binarySearch(List<? extends T> sortedList, @Nullable T key2) {
        return Collections.binarySearch(sortedList, key2, this);
    }

    @VisibleForTesting
    static class IncomparableValueException
    extends ClassCastException {
        final Object value;
        private static final long serialVersionUID = 0L;

        IncomparableValueException(Object value) {
            String string2 = String.valueOf(String.valueOf(value));
            super(new StringBuilder(22 + string2.length()).append("Cannot compare value: ").append(string2).toString());
            this.value = value;
        }
    }

    @VisibleForTesting
    static class ArbitraryOrdering
    extends Ordering<Object> {
        private Map<Object, Integer> uids = Platform.tryWeakKeys(new MapMaker()).makeComputingMap(new Function<Object, Integer>(){
            final AtomicInteger counter = new AtomicInteger(0);

            @Override
            public Integer apply(Object from) {
                return this.counter.getAndIncrement();
            }
        });

        ArbitraryOrdering() {
        }

        @Override
        public int compare(Object left2, Object right2) {
            int rightCode;
            if (left2 == right2) {
                return 0;
            }
            if (left2 == null) {
                return -1;
            }
            if (right2 == null) {
                return 1;
            }
            int leftCode = this.identityHashCode(left2);
            if (leftCode != (rightCode = this.identityHashCode(right2))) {
                return leftCode < rightCode ? -1 : 1;
            }
            int result = this.uids.get(left2).compareTo(this.uids.get(right2));
            if (result == 0) {
                throw new AssertionError();
            }
            return result;
        }

        public String toString() {
            return "Ordering.arbitrary()";
        }

        int identityHashCode(Object object) {
            return System.identityHashCode(object);
        }
    }

    private static class ArbitraryOrderingHolder {
        static final Ordering<Object> ARBITRARY_ORDERING = new ArbitraryOrdering();

        private ArbitraryOrderingHolder() {
        }
    }
}

