/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.atomic.AtomicInteger;
import rx.Observable;
import rx.Producer;
import rx.Scheduler;
import rx.Subscriber;
import rx.functions.Action0;
import rx.functions.Func2;
import rx.internal.producers.ProducerArbiter;
import rx.schedulers.Schedulers;
import rx.subscriptions.SerialSubscription;

public final class OperatorRetryWithPredicate<T>
implements Observable.Operator<T, Observable<T>> {
    final Func2<Integer, Throwable, Boolean> predicate;

    public OperatorRetryWithPredicate(Func2<Integer, Throwable, Boolean> predicate) {
        this.predicate = predicate;
    }

    @Override
    public Subscriber<? super Observable<T>> call(Subscriber<? super T> child) {
        Scheduler.Worker inner = Schedulers.trampoline().createWorker();
        child.add(inner);
        SerialSubscription serialSubscription = new SerialSubscription();
        child.add(serialSubscription);
        ProducerArbiter pa = new ProducerArbiter();
        child.setProducer(pa);
        return new SourceSubscriber<T>(child, this.predicate, inner, serialSubscription, pa);
    }

    static final class SourceSubscriber<T>
    extends Subscriber<Observable<T>> {
        final Subscriber<? super T> child;
        final Func2<Integer, Throwable, Boolean> predicate;
        final Scheduler.Worker inner;
        final SerialSubscription serialSubscription;
        final ProducerArbiter pa;
        final AtomicInteger attempts = new AtomicInteger();

        public SourceSubscriber(Subscriber<? super T> child, Func2<Integer, Throwable, Boolean> predicate, Scheduler.Worker inner, SerialSubscription serialSubscription, ProducerArbiter pa) {
            this.child = child;
            this.predicate = predicate;
            this.inner = inner;
            this.serialSubscription = serialSubscription;
            this.pa = pa;
        }

        @Override
        public void onCompleted() {
        }

        @Override
        public void onError(Throwable e2) {
            this.child.onError(e2);
        }

        @Override
        public void onNext(final Observable<T> o) {
            this.inner.schedule(new Action0(){

                @Override
                public void call() {
                    final 1 _self = this;
                    SourceSubscriber.this.attempts.incrementAndGet();
                    Subscriber subscriber2 = new Subscriber<T>(){
                        boolean done;

                        @Override
                        public void onCompleted() {
                            if (!this.done) {
                                this.done = true;
                                SourceSubscriber.this.child.onCompleted();
                            }
                        }

                        @Override
                        public void onError(Throwable e2) {
                            if (!this.done) {
                                this.done = true;
                                if (SourceSubscriber.this.predicate.call(SourceSubscriber.this.attempts.get(), e2).booleanValue() && !SourceSubscriber.this.inner.isUnsubscribed()) {
                                    SourceSubscriber.this.inner.schedule(_self);
                                } else {
                                    SourceSubscriber.this.child.onError(e2);
                                }
                            }
                        }

                        @Override
                        public void onNext(T v) {
                            if (!this.done) {
                                SourceSubscriber.this.child.onNext(v);
                                SourceSubscriber.this.pa.produced(1L);
                            }
                        }

                        @Override
                        public void setProducer(Producer p) {
                            SourceSubscriber.this.pa.setProducer(p);
                        }
                    };
                    SourceSubscriber.this.serialSubscription.set(subscriber2);
                    o.unsafeSubscribe(subscriber2);
                }
            });
        }
    }
}

