/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.spi;

import java.io.Serializable;
import org.apache.log4j.helpers.LogLog;

public class LocationInfo
implements Serializable {
    transient String lineNumber;
    transient String fileName;
    transient String className;
    transient String methodName;
    public String fullInfo;
    public static final String NA = "?";
    static final long serialVersionUID = -1325822038990805636L;
    public static final LocationInfo NA_LOCATION_INFO = new LocationInfo("?", "?", "?", "?");

    public LocationInfo(Throwable t, String fqnOfCallingClass) {
        if (t == null || fqnOfCallingClass == null) {
            return;
        }
        try {
            StackTraceElement[] elements = t.getStackTrace();
            String prevClass = NA;
            for (int i = elements.length - 1; i >= 0; --i) {
                String thisClass = elements[i].getClassName();
                if (fqnOfCallingClass.equals(thisClass)) {
                    int caller = i + 1;
                    if (caller < elements.length) {
                        int line;
                        this.className = prevClass;
                        this.methodName = elements[caller].getMethodName();
                        this.fileName = elements[caller].getFileName();
                        if (this.fileName == null) {
                            this.fileName = NA;
                        }
                        this.lineNumber = (line = elements[caller].getLineNumber()) < 0 ? NA : Integer.toString(line);
                        StringBuilder buf = new StringBuilder();
                        buf.append(this.className);
                        buf.append(".");
                        buf.append(this.methodName);
                        buf.append("(");
                        buf.append(this.fileName);
                        buf.append(":");
                        buf.append(this.lineNumber);
                        buf.append(")");
                        this.fullInfo = buf.toString();
                    }
                    return;
                }
                prevClass = thisClass;
            }
            return;
        }
        catch (RuntimeException ex) {
            LogLog.debug("LocationInfo construction failed", ex);
            return;
        }
    }

    private static final void appendFragment(StringBuilder buf, String fragment) {
        if (fragment == null) {
            buf.append(NA);
        } else {
            buf.append(fragment);
        }
    }

    public LocationInfo(String file2, String classname, String method, String line) {
        this.fileName = file2;
        this.className = classname;
        this.methodName = method;
        this.lineNumber = line;
        StringBuilder buf = new StringBuilder();
        LocationInfo.appendFragment(buf, classname);
        buf.append(".");
        LocationInfo.appendFragment(buf, method);
        buf.append("(");
        LocationInfo.appendFragment(buf, file2);
        buf.append(":");
        LocationInfo.appendFragment(buf, line);
        buf.append(")");
        this.fullInfo = buf.toString();
    }

    public String getClassName() {
        if (this.fullInfo == null) {
            return NA;
        }
        if (this.className != null) {
            return this.className;
        }
        int iend = this.fullInfo.lastIndexOf(40);
        if (iend == -1) {
            this.className = NA;
        } else {
            iend = this.fullInfo.lastIndexOf(46, iend);
            int ibegin = 0;
            this.className = iend == -1 ? NA : this.fullInfo.substring(ibegin, iend);
        }
        return this.className;
    }

    public String getFileName() {
        if (this.fullInfo == null) {
            return NA;
        }
        if (this.fileName == null) {
            int iend = this.fullInfo.lastIndexOf(58);
            if (iend == -1) {
                this.fileName = NA;
            } else {
                int ibegin = this.fullInfo.lastIndexOf(40, iend - 1);
                this.fileName = this.fullInfo.substring(ibegin + 1, iend);
            }
        }
        return this.fileName;
    }

    public String getLineNumber() {
        if (this.fullInfo == null) {
            return NA;
        }
        if (this.lineNumber == null) {
            int iend = this.fullInfo.lastIndexOf(41);
            int ibegin = this.fullInfo.lastIndexOf(58, iend - 1);
            this.lineNumber = ibegin == -1 ? NA : this.fullInfo.substring(ibegin + 1, iend);
        }
        return this.lineNumber;
    }

    public String getMethodName() {
        if (this.fullInfo == null) {
            return NA;
        }
        if (this.methodName == null) {
            int iend = this.fullInfo.lastIndexOf(40);
            int ibegin = this.fullInfo.lastIndexOf(46, iend);
            this.methodName = ibegin == -1 ? NA : this.fullInfo.substring(ibegin + 1, iend);
        }
        return this.methodName;
    }
}

