/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.config;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.config.PropertyGetter;

public class PropertyPrinter
implements PropertyGetter.PropertyCallback {
    protected int numAppenders = 0;
    protected Hashtable appenderNames = new Hashtable();
    protected Hashtable layoutNames = new Hashtable();
    protected PrintWriter out;
    protected boolean doCapitalize;

    public PropertyPrinter(PrintWriter out) {
        this(out, false);
    }

    public PropertyPrinter(PrintWriter out, boolean doCapitalize) {
        this.out = out;
        this.doCapitalize = doCapitalize;
        this.print(out);
        out.flush();
    }

    protected String genAppName() {
        return "A" + this.numAppenders++;
    }

    protected boolean isGenAppName(String name2) {
        if (name2.length() < 2 || name2.charAt(0) != 'A') {
            return false;
        }
        for (int i = 0; i < name2.length(); ++i) {
            if (name2.charAt(i) >= '0' && name2.charAt(i) <= '9') continue;
            return false;
        }
        return true;
    }

    public void print(PrintWriter out) {
        this.printOptions(out, Logger.getRootLogger());
        Enumeration cats = LogManager.getCurrentLoggers();
        while (cats.hasMoreElements()) {
            this.printOptions(out, (Logger)cats.nextElement());
        }
    }

    protected void printOptions(PrintWriter out, Category cat2) {
        String catKey;
        String appenderString;
        Enumeration appenders = cat2.getAllAppenders();
        Level prio = cat2.getLevel();
        String string2 = appenderString = prio == null ? "" : prio.toString();
        while (appenders.hasMoreElements()) {
            Appender app = (Appender)appenders.nextElement();
            String name2 = (String)this.appenderNames.get(app);
            if (name2 == null) {
                name2 = app.getName();
                if (name2 == null || this.isGenAppName(name2)) {
                    name2 = this.genAppName();
                }
                this.appenderNames.put(app, name2);
                this.printOptions(out, app, "log4j.appender." + name2);
                if (app.getLayout() != null) {
                    this.printOptions(out, app.getLayout(), "log4j.appender." + name2 + ".layout");
                }
            }
            appenderString = appenderString + ", " + name2;
        }
        String string3 = catKey = cat2 == Logger.getRootLogger() ? "log4j.rootLogger" : "log4j.logger." + cat2.getName();
        if (appenderString != "") {
            out.println(catKey + "=" + appenderString);
        }
        if (!cat2.getAdditivity() && cat2 != Logger.getRootLogger()) {
            out.println("log4j.additivity." + cat2.getName() + "=false");
        }
    }

    protected void printOptions(PrintWriter out, Logger cat2) {
        this.printOptions(out, (Category)cat2);
    }

    protected void printOptions(PrintWriter out, Object obj, String fullname) {
        out.println(fullname + "=" + obj.getClass().getName());
        PropertyGetter.getProperties(obj, this, fullname + ".");
    }

    public void foundProperty(Object obj, String prefix, String name2, Object value) {
        if (obj instanceof Appender && "name".equals(name2)) {
            return;
        }
        if (this.doCapitalize) {
            name2 = PropertyPrinter.capitalize(name2);
        }
        this.out.println(prefix + name2 + "=" + value.toString());
    }

    public static String capitalize(String name2) {
        if (Character.isLowerCase(name2.charAt(0)) && (name2.length() == 1 || Character.isLowerCase(name2.charAt(1)))) {
            StringBuilder newname = new StringBuilder(name2);
            newname.setCharAt(0, Character.toUpperCase(name2.charAt(0)));
            return newname.toString();
        }
        return name2;
    }

    public static void main(String[] args) {
        new PropertyPrinter(new PrintWriter(System.out));
    }
}

