/*
 * Decompiled with CFR 0.152.
 */
package mantis.io.reactivex.netty.metrics;

import java.util.concurrent.TimeUnit;

public class Clock {
    public static final long SYSTEM_TIME_DISABLED_TIME = -1L;
    private final long startTimeMillis = System.currentTimeMillis();
    private long endTimeMillis = -1L;
    private long durationMillis = -1L;
    private static volatile boolean disableSystemTimeCalls;

    public long stop() {
        if (-1L != this.endTimeMillis) {
            this.endTimeMillis = System.currentTimeMillis();
            this.durationMillis = this.endTimeMillis - this.startTimeMillis;
        }
        return this.durationMillis;
    }

    public long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    public long getStartTime(TimeUnit targetUnit) {
        return targetUnit.convert(this.startTimeMillis, TimeUnit.MILLISECONDS);
    }

    public long getDurationInMillis() {
        if (this.isRunning()) {
            throw new IllegalStateException("The clock is not yet stopped.");
        }
        return this.durationMillis;
    }

    public long getDuration(TimeUnit targetUnit) {
        if (this.isRunning()) {
            throw new IllegalStateException("The clock is not yet stopped.");
        }
        return targetUnit.convert(this.durationMillis, TimeUnit.MILLISECONDS);
    }

    public boolean isRunning() {
        return -1L != this.durationMillis;
    }

    public static void disableSystemTimeCalls() {
        disableSystemTimeCalls = true;
    }

    public static long newStartTimeMillis() {
        return disableSystemTimeCalls ? -1L : System.currentTimeMillis();
    }

    public static long newStartTime(TimeUnit timeUnit) {
        if (disableSystemTimeCalls) {
            return -1L;
        }
        if (TimeUnit.MILLISECONDS == timeUnit) {
            return Clock.newStartTimeMillis();
        }
        return timeUnit.convert(Clock.newStartTimeMillis(), TimeUnit.MILLISECONDS);
    }

    public static long onEnd(long startTime, TimeUnit timeUnit) {
        if (disableSystemTimeCalls) {
            return -1L;
        }
        if (TimeUnit.MILLISECONDS == timeUnit) {
            return Clock.onEndMillis(startTime);
        }
        long startTimeMillis = TimeUnit.MILLISECONDS.convert(startTime, timeUnit);
        return timeUnit.convert(Clock.onEndMillis(startTimeMillis), TimeUnit.MILLISECONDS);
    }

    public static long onEndMillis(long startTimeMillis) {
        if (disableSystemTimeCalls) {
            return -1L;
        }
        return System.currentTimeMillis() - startTimeMillis;
    }
}

