/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.com.google.common.collect;

import io.mantisrx.shaded.com.google.common.annotations.Beta;
import io.mantisrx.shaded.com.google.common.collect.CollectPreconditions;
import io.mantisrx.shaded.com.google.common.collect.ForwardingSortedMap;
import io.mantisrx.shaded.com.google.common.collect.Iterables;
import io.mantisrx.shaded.com.google.common.collect.Iterators;
import io.mantisrx.shaded.com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.SortedMap;

public abstract class ForwardingNavigableMap<K, V>
extends ForwardingSortedMap<K, V>
implements NavigableMap<K, V> {
    protected ForwardingNavigableMap() {
    }

    @Override
    protected abstract NavigableMap<K, V> delegate();

    @Override
    public Map.Entry<K, V> lowerEntry(K key2) {
        return this.delegate().lowerEntry(key2);
    }

    protected Map.Entry<K, V> standardLowerEntry(K key2) {
        return this.headMap(key2, false).lastEntry();
    }

    @Override
    public K lowerKey(K key2) {
        return this.delegate().lowerKey(key2);
    }

    protected K standardLowerKey(K key2) {
        return Maps.keyOrNull(this.lowerEntry(key2));
    }

    @Override
    public Map.Entry<K, V> floorEntry(K key2) {
        return this.delegate().floorEntry(key2);
    }

    protected Map.Entry<K, V> standardFloorEntry(K key2) {
        return this.headMap(key2, true).lastEntry();
    }

    @Override
    public K floorKey(K key2) {
        return this.delegate().floorKey(key2);
    }

    protected K standardFloorKey(K key2) {
        return Maps.keyOrNull(this.floorEntry(key2));
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K key2) {
        return this.delegate().ceilingEntry(key2);
    }

    protected Map.Entry<K, V> standardCeilingEntry(K key2) {
        return this.tailMap(key2, true).firstEntry();
    }

    @Override
    public K ceilingKey(K key2) {
        return this.delegate().ceilingKey(key2);
    }

    protected K standardCeilingKey(K key2) {
        return Maps.keyOrNull(this.ceilingEntry(key2));
    }

    @Override
    public Map.Entry<K, V> higherEntry(K key2) {
        return this.delegate().higherEntry(key2);
    }

    protected Map.Entry<K, V> standardHigherEntry(K key2) {
        return this.tailMap(key2, false).firstEntry();
    }

    @Override
    public K higherKey(K key2) {
        return this.delegate().higherKey(key2);
    }

    protected K standardHigherKey(K key2) {
        return Maps.keyOrNull(this.higherEntry(key2));
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        return this.delegate().firstEntry();
    }

    protected Map.Entry<K, V> standardFirstEntry() {
        return Iterables.getFirst(this.entrySet(), null);
    }

    protected K standardFirstKey() {
        Map.Entry<K, V> entry = this.firstEntry();
        if (entry == null) {
            throw new NoSuchElementException();
        }
        return entry.getKey();
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        return this.delegate().lastEntry();
    }

    protected Map.Entry<K, V> standardLastEntry() {
        return Iterables.getFirst(this.descendingMap().entrySet(), null);
    }

    protected K standardLastKey() {
        Map.Entry<K, V> entry = this.lastEntry();
        if (entry == null) {
            throw new NoSuchElementException();
        }
        return entry.getKey();
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        return this.delegate().pollFirstEntry();
    }

    protected Map.Entry<K, V> standardPollFirstEntry() {
        return Iterators.pollNext(this.entrySet().iterator());
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        return this.delegate().pollLastEntry();
    }

    protected Map.Entry<K, V> standardPollLastEntry() {
        return Iterators.pollNext(this.descendingMap().entrySet().iterator());
    }

    @Override
    public NavigableMap<K, V> descendingMap() {
        return this.delegate().descendingMap();
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        return this.delegate().navigableKeySet();
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        return this.delegate().descendingKeySet();
    }

    @Beta
    protected NavigableSet<K> standardDescendingKeySet() {
        return this.descendingMap().navigableKeySet();
    }

    @Override
    protected SortedMap<K, V> standardSubMap(K fromKey, K toKey) {
        return this.subMap(fromKey, true, toKey, false);
    }

    @Override
    public NavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        return this.delegate().subMap(fromKey, fromInclusive, toKey, toInclusive);
    }

    @Override
    public NavigableMap<K, V> headMap(K toKey, boolean inclusive) {
        return this.delegate().headMap(toKey, inclusive);
    }

    @Override
    public NavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
        return this.delegate().tailMap(fromKey, inclusive);
    }

    protected SortedMap<K, V> standardHeadMap(K toKey) {
        return this.headMap(toKey, false);
    }

    protected SortedMap<K, V> standardTailMap(K fromKey) {
        return this.tailMap(fromKey, true);
    }

    @Beta
    protected class StandardNavigableKeySet
    extends Maps.NavigableKeySet<K, V> {
        public StandardNavigableKeySet() {
            super(ForwardingNavigableMap.this);
        }
    }

    @Beta
    protected class StandardDescendingMap
    extends Maps.DescendingMap<K, V> {
        @Override
        NavigableMap<K, V> forward() {
            return ForwardingNavigableMap.this;
        }

        @Override
        protected Iterator<Map.Entry<K, V>> entryIterator() {
            return new Iterator<Map.Entry<K, V>>(){
                private Map.Entry<K, V> toRemove = null;
                private Map.Entry<K, V> nextOrNull = StandardDescendingMap.this.forward().lastEntry();

                @Override
                public boolean hasNext() {
                    return this.nextOrNull != null;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Map.Entry<K, V> next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    try {
                        Map.Entry entry = this.nextOrNull;
                        return entry;
                    }
                    finally {
                        this.toRemove = this.nextOrNull;
                        this.nextOrNull = StandardDescendingMap.this.forward().lowerEntry(this.nextOrNull.getKey());
                    }
                }

                @Override
                public void remove() {
                    CollectPreconditions.checkRemove(this.toRemove != null);
                    StandardDescendingMap.this.forward().remove(this.toRemove.getKey());
                    this.toRemove = null;
                }
            };
        }
    }
}

