/*
 * Decompiled with CFR 0.152.
 */
package org.jctools.queues.atomic;

import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import org.jctools.queues.atomic.LinkedQueueAtomicNode;

abstract class BaseLinkedAtomicQueue<E>
extends AbstractQueue<E> {
    private final AtomicReference<LinkedQueueAtomicNode<E>> producerNode = new AtomicReference();
    private final AtomicReference<LinkedQueueAtomicNode<E>> consumerNode = new AtomicReference();

    protected final LinkedQueueAtomicNode<E> lvProducerNode() {
        return this.producerNode.get();
    }

    protected final LinkedQueueAtomicNode<E> lpProducerNode() {
        return this.producerNode.get();
    }

    protected final void spProducerNode(LinkedQueueAtomicNode<E> node2) {
        this.producerNode.lazySet(node2);
    }

    protected final LinkedQueueAtomicNode<E> xchgProducerNode(LinkedQueueAtomicNode<E> node2) {
        return this.producerNode.getAndSet(node2);
    }

    protected final LinkedQueueAtomicNode<E> lvConsumerNode() {
        return this.consumerNode.get();
    }

    protected final LinkedQueueAtomicNode<E> lpConsumerNode() {
        return this.consumerNode.get();
    }

    protected final void spConsumerNode(LinkedQueueAtomicNode<E> node2) {
        this.consumerNode.lazySet(node2);
    }

    @Override
    public final Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int size() {
        int size;
        LinkedQueueAtomicNode<E> chaserNode = this.lvConsumerNode();
        LinkedQueueAtomicNode<E> producerNode = this.lvProducerNode();
        for (size = 0; chaserNode != producerNode && chaserNode != null && size < Integer.MAX_VALUE; ++size) {
            LinkedQueueAtomicNode<E> next2 = chaserNode.lvNext();
            if (next2 == chaserNode) {
                next2 = this.lvConsumerNode();
            }
            chaserNode = next2;
        }
        return size;
    }

    @Override
    public final boolean isEmpty() {
        return this.lvConsumerNode() == this.lvProducerNode();
    }

    protected E getSingleConsumerNodeValue(LinkedQueueAtomicNode<E> currConsumerNode, LinkedQueueAtomicNode<E> nextNode) {
        E nextValue = nextNode.getAndNullValue();
        currConsumerNode.soNext(currConsumerNode);
        this.spConsumerNode(nextNode);
        return nextValue;
    }
}

