/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.jboss.netty.channel.socket.nio;

import io.mantisrx.shaded.org.jboss.netty.channel.ChannelEvent;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelFuture;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelFutureListener;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelPipeline;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelState;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelStateEvent;
import io.mantisrx.shaded.org.jboss.netty.channel.Channels;
import io.mantisrx.shaded.org.jboss.netty.channel.MessageEvent;
import io.mantisrx.shaded.org.jboss.netty.channel.socket.nio.AbstractNioChannelSink;
import io.mantisrx.shaded.org.jboss.netty.channel.socket.nio.NioDatagramChannel;
import io.mantisrx.shaded.org.jboss.netty.channel.socket.nio.NioDatagramWorker;
import io.mantisrx.shaded.org.jboss.netty.channel.socket.nio.WorkerPool;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NioDatagramPipelineSink
extends AbstractNioChannelSink {
    private final WorkerPool<NioDatagramWorker> workerPool;

    NioDatagramPipelineSink(WorkerPool<NioDatagramWorker> workerPool) {
        this.workerPool = workerPool;
    }

    @Override
    public void eventSunk(ChannelPipeline pipeline, ChannelEvent e2) throws Exception {
        NioDatagramChannel channel = (NioDatagramChannel)e2.getChannel();
        ChannelFuture future2 = e2.getFuture();
        if (e2 instanceof ChannelStateEvent) {
            ChannelStateEvent stateEvent = (ChannelStateEvent)e2;
            ChannelState state = stateEvent.getState();
            Object value = stateEvent.getValue();
            switch (state) {
                case OPEN: {
                    if (!Boolean.FALSE.equals(value)) break;
                    channel.worker.close(channel, future2);
                    break;
                }
                case BOUND: {
                    if (value != null) {
                        NioDatagramPipelineSink.bind(channel, future2, (InetSocketAddress)value);
                        break;
                    }
                    channel.worker.close(channel, future2);
                    break;
                }
                case CONNECTED: {
                    if (value != null) {
                        NioDatagramPipelineSink.connect(channel, future2, (InetSocketAddress)value);
                        break;
                    }
                    NioDatagramWorker.disconnect(channel, future2);
                    break;
                }
                case INTEREST_OPS: {
                    channel.worker.setInterestOps(channel, future2, (Integer)value);
                }
            }
        } else if (e2 instanceof MessageEvent) {
            MessageEvent event = (MessageEvent)e2;
            boolean offered = channel.writeBufferQueue.offer(event);
            assert (offered);
            channel.worker.writeFromUserCode(channel);
        }
    }

    private static void close(NioDatagramChannel channel, ChannelFuture future2) {
        try {
            channel.getDatagramChannel().socket().close();
            if (channel.setClosed()) {
                future2.setSuccess();
                if (channel.isBound()) {
                    Channels.fireChannelUnbound(channel);
                }
                Channels.fireChannelClosed(channel);
            } else {
                future2.setSuccess();
            }
        }
        catch (Throwable t) {
            future2.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void bind(NioDatagramChannel channel, ChannelFuture future2, InetSocketAddress address) {
        boolean bound = false;
        boolean started = false;
        try {
            try {
                channel.getDatagramChannel().socket().bind(address);
                bound = true;
                future2.setSuccess();
                Channels.fireChannelBound(channel, (SocketAddress)address);
                channel.worker.register(channel, null);
                return;
            }
            catch (Throwable t) {
                future2.setFailure(t);
                Channels.fireExceptionCaught(channel, t);
                Object var7_6 = null;
                if (started) return;
                if (!bound) return;
                NioDatagramPipelineSink.close(channel, future2);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (started || !bound) throw throwable;
            NioDatagramPipelineSink.close(channel, future2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void connect(NioDatagramChannel channel, ChannelFuture future2, InetSocketAddress remoteAddress) {
        boolean bound = channel.isBound();
        boolean connected = false;
        boolean workerStarted = false;
        future2.addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
        channel.remoteAddress = null;
        try {
            try {
                channel.getDatagramChannel().connect(remoteAddress);
                connected = true;
                future2.setSuccess();
                if (!bound) {
                    Channels.fireChannelBound(channel, (SocketAddress)channel.getLocalAddress());
                }
                Channels.fireChannelConnected(channel, (SocketAddress)channel.getRemoteAddress());
                if (!bound) {
                    channel.worker.register(channel, future2);
                }
                workerStarted = true;
            }
            catch (Throwable t) {
                future2.setFailure(t);
                Channels.fireExceptionCaught(channel, t);
                Object var8_7 = null;
                if (connected && !workerStarted) {
                    channel.worker.close(channel, future2);
                }
            }
            Object var8_6 = null;
            if (connected && !workerStarted) {
                channel.worker.close(channel, future2);
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (connected && !workerStarted) {
                channel.worker.close(channel, future2);
            }
            throw throwable;
        }
    }

    NioDatagramWorker nextWorker() {
        return this.workerPool.nextWorker();
    }
}

