/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper.server.quorum;

import io.mantisrx.shaded.org.apache.zookeeper.KeeperException;
import io.mantisrx.shaded.org.apache.zookeeper.jmx.MBeanRegistry;
import io.mantisrx.shaded.org.apache.zookeeper.server.DataTreeBean;
import io.mantisrx.shaded.org.apache.zookeeper.server.FinalRequestProcessor;
import io.mantisrx.shaded.org.apache.zookeeper.server.PrepRequestProcessor;
import io.mantisrx.shaded.org.apache.zookeeper.server.ServerCnxn;
import io.mantisrx.shaded.org.apache.zookeeper.server.SessionTrackerImpl;
import io.mantisrx.shaded.org.apache.zookeeper.server.ZKDatabase;
import io.mantisrx.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import io.mantisrx.shaded.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import io.mantisrx.shaded.org.apache.zookeeper.server.quorum.CommitProcessor;
import io.mantisrx.shaded.org.apache.zookeeper.server.quorum.Leader;
import io.mantisrx.shaded.org.apache.zookeeper.server.quorum.LeaderBean;
import io.mantisrx.shaded.org.apache.zookeeper.server.quorum.LocalPeerBean;
import io.mantisrx.shaded.org.apache.zookeeper.server.quorum.ProposalRequestProcessor;
import io.mantisrx.shaded.org.apache.zookeeper.server.quorum.QuorumPeer;
import io.mantisrx.shaded.org.apache.zookeeper.server.quorum.QuorumZooKeeperServer;
import java.io.IOException;

public class LeaderZooKeeperServer
extends QuorumZooKeeperServer {
    CommitProcessor commitProcessor;

    LeaderZooKeeperServer(FileTxnSnapLog logFactory, QuorumPeer self, ZooKeeperServer.DataTreeBuilder treeBuilder, ZKDatabase zkDb) throws IOException {
        super(logFactory, self.tickTime, self.minSessionTimeout, self.maxSessionTimeout, treeBuilder, zkDb, self);
    }

    public Leader getLeader() {
        return this.self.leader;
    }

    @Override
    protected void setupRequestProcessors() {
        FinalRequestProcessor finalProcessor = new FinalRequestProcessor(this);
        Leader.ToBeAppliedRequestProcessor toBeAppliedProcessor = new Leader.ToBeAppliedRequestProcessor(finalProcessor, this.getLeader().toBeApplied);
        this.commitProcessor = new CommitProcessor(toBeAppliedProcessor, Long.toString(this.getServerId()), false, this.getZooKeeperServerListener());
        this.commitProcessor.start();
        ProposalRequestProcessor proposalProcessor = new ProposalRequestProcessor(this, this.commitProcessor);
        proposalProcessor.initialize();
        this.firstProcessor = new PrepRequestProcessor(this, proposalProcessor);
        ((PrepRequestProcessor)this.firstProcessor).start();
    }

    @Override
    public int getGlobalOutstandingLimit() {
        return super.getGlobalOutstandingLimit() / (this.self.getQuorumSize() - 1);
    }

    @Override
    public void createSessionTracker() {
        this.sessionTracker = new SessionTrackerImpl(this, this.getZKDatabase().getSessionWithTimeOuts(), this.tickTime, this.self.getId(), this.getZooKeeperServerListener());
    }

    @Override
    protected void startSessionTracker() {
        ((SessionTrackerImpl)this.sessionTracker).start();
    }

    public boolean touch(long sess, int to) {
        return this.sessionTracker.touchSession(sess, to);
    }

    @Override
    protected void registerJMX() {
        try {
            this.jmxDataTreeBean = new DataTreeBean(this.getZKDatabase().getDataTree());
            MBeanRegistry.getInstance().register(this.jmxDataTreeBean, this.jmxServerBean);
        }
        catch (Exception e2) {
            LOG.warn("Failed to register with JMX", e2);
            this.jmxDataTreeBean = null;
        }
    }

    public void registerJMX(LeaderBean leaderBean, LocalPeerBean localPeerBean) {
        if (this.self.jmxLeaderElectionBean != null) {
            try {
                MBeanRegistry.getInstance().unregister(this.self.jmxLeaderElectionBean);
            }
            catch (Exception e2) {
                LOG.warn("Failed to register with JMX", e2);
            }
            this.self.jmxLeaderElectionBean = null;
        }
        try {
            this.jmxServerBean = leaderBean;
            MBeanRegistry.getInstance().register(leaderBean, localPeerBean);
        }
        catch (Exception e3) {
            LOG.warn("Failed to register with JMX", e3);
            this.jmxServerBean = null;
        }
    }

    @Override
    protected void unregisterJMX() {
        try {
            if (this.jmxDataTreeBean != null) {
                MBeanRegistry.getInstance().unregister(this.jmxDataTreeBean);
            }
        }
        catch (Exception e2) {
            LOG.warn("Failed to unregister with JMX", e2);
        }
        this.jmxDataTreeBean = null;
    }

    protected void unregisterJMX(Leader leader) {
        try {
            if (this.jmxServerBean != null) {
                MBeanRegistry.getInstance().unregister(this.jmxServerBean);
            }
        }
        catch (Exception e2) {
            LOG.warn("Failed to unregister with JMX", e2);
        }
        this.jmxServerBean = null;
    }

    @Override
    public String getState() {
        return "leader";
    }

    @Override
    public long getServerId() {
        return this.self.getId();
    }

    @Override
    protected void revalidateSession(ServerCnxn cnxn, long sessionId, int sessionTimeout) throws IOException {
        super.revalidateSession(cnxn, sessionId, sessionTimeout);
        try {
            this.setOwner(sessionId, ServerCnxn.me);
        }
        catch (KeeperException.SessionExpiredException sessionExpiredException) {
            // empty catch block
        }
    }
}

