/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.curator.framework.imps;

import io.mantisrx.shaded.org.apache.curator.RetryLoop;
import io.mantisrx.shaded.org.apache.curator.drivers.OperationTrace;
import io.mantisrx.shaded.org.apache.curator.framework.api.BackgroundCallback;
import io.mantisrx.shaded.org.apache.curator.framework.api.BackgroundPathAndBytesable;
import io.mantisrx.shaded.org.apache.curator.framework.api.CuratorEventType;
import io.mantisrx.shaded.org.apache.curator.framework.api.ErrorListenerPathAndBytesable;
import io.mantisrx.shaded.org.apache.curator.framework.api.PathAndBytesable;
import io.mantisrx.shaded.org.apache.curator.framework.api.SetDataBackgroundVersionable;
import io.mantisrx.shaded.org.apache.curator.framework.api.SetDataBuilder;
import io.mantisrx.shaded.org.apache.curator.framework.api.UnhandledErrorListener;
import io.mantisrx.shaded.org.apache.curator.framework.api.VersionPathAndBytesable;
import io.mantisrx.shaded.org.apache.curator.framework.api.transaction.CuratorTransactionBridge;
import io.mantisrx.shaded.org.apache.curator.framework.api.transaction.OperationType;
import io.mantisrx.shaded.org.apache.curator.framework.api.transaction.TransactionSetDataBuilder;
import io.mantisrx.shaded.org.apache.curator.framework.imps.BackgroundOperation;
import io.mantisrx.shaded.org.apache.curator.framework.imps.Backgrounding;
import io.mantisrx.shaded.org.apache.curator.framework.imps.CuratorEventImpl;
import io.mantisrx.shaded.org.apache.curator.framework.imps.CuratorFrameworkImpl;
import io.mantisrx.shaded.org.apache.curator.framework.imps.CuratorMultiTransactionRecord;
import io.mantisrx.shaded.org.apache.curator.framework.imps.CuratorTransactionImpl;
import io.mantisrx.shaded.org.apache.curator.framework.imps.OperationAndData;
import io.mantisrx.shaded.org.apache.curator.framework.imps.PathAndBytes;
import io.mantisrx.shaded.org.apache.zookeeper.AsyncCallback;
import io.mantisrx.shaded.org.apache.zookeeper.Op;
import io.mantisrx.shaded.org.apache.zookeeper.data.Stat;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

class SetDataBuilderImpl
implements SetDataBuilder,
BackgroundOperation<PathAndBytes>,
ErrorListenerPathAndBytesable<Stat> {
    private final CuratorFrameworkImpl client;
    private Backgrounding backgrounding;
    private int version;
    private boolean compress;

    SetDataBuilderImpl(CuratorFrameworkImpl client) {
        this.client = client;
        this.backgrounding = new Backgrounding();
        this.version = -1;
        this.compress = false;
    }

    TransactionSetDataBuilder asTransactionSetDataBuilder(final CuratorTransactionImpl curatorTransaction, final CuratorMultiTransactionRecord transaction) {
        return new TransactionSetDataBuilder(){

            @Override
            public CuratorTransactionBridge forPath(String path2, byte[] data2) throws Exception {
                if (SetDataBuilderImpl.this.compress) {
                    data2 = SetDataBuilderImpl.this.client.getCompressionProvider().compress(path2, data2);
                }
                String fixedPath = SetDataBuilderImpl.this.client.fixForNamespace(path2);
                transaction.add(Op.setData(fixedPath, data2, SetDataBuilderImpl.this.version), OperationType.SET_DATA, path2);
                return curatorTransaction;
            }

            @Override
            public CuratorTransactionBridge forPath(String path2) throws Exception {
                return this.forPath(path2, SetDataBuilderImpl.this.client.getDefaultData());
            }

            @Override
            public PathAndBytesable<CuratorTransactionBridge> withVersion(int version) {
                SetDataBuilderImpl.this.withVersion(version);
                return this;
            }

            @Override
            public VersionPathAndBytesable<CuratorTransactionBridge> compressed() {
                SetDataBuilderImpl.this.compress = true;
                return this;
            }
        };
    }

    @Override
    public SetDataBackgroundVersionable compressed() {
        this.compress = true;
        return new SetDataBackgroundVersionable(){

            @Override
            public ErrorListenerPathAndBytesable<Stat> inBackground() {
                return SetDataBuilderImpl.this.inBackground();
            }

            @Override
            public ErrorListenerPathAndBytesable<Stat> inBackground(BackgroundCallback callback, Object context) {
                return SetDataBuilderImpl.this.inBackground(callback, context);
            }

            @Override
            public ErrorListenerPathAndBytesable<Stat> inBackground(BackgroundCallback callback, Object context, Executor executor) {
                return SetDataBuilderImpl.this.inBackground(callback, context, executor);
            }

            @Override
            public ErrorListenerPathAndBytesable<Stat> inBackground(Object context) {
                return SetDataBuilderImpl.this.inBackground(context);
            }

            @Override
            public ErrorListenerPathAndBytesable<Stat> inBackground(BackgroundCallback callback) {
                return SetDataBuilderImpl.this.inBackground(callback);
            }

            @Override
            public ErrorListenerPathAndBytesable<Stat> inBackground(BackgroundCallback callback, Executor executor) {
                return SetDataBuilderImpl.this.inBackground(callback, executor);
            }

            @Override
            public Stat forPath(String path2, byte[] data2) throws Exception {
                return SetDataBuilderImpl.this.forPath(path2, data2);
            }

            @Override
            public Stat forPath(String path2) throws Exception {
                return SetDataBuilderImpl.this.forPath(path2);
            }

            @Override
            public BackgroundPathAndBytesable<Stat> withVersion(int version) {
                return SetDataBuilderImpl.this.withVersion(version);
            }
        };
    }

    @Override
    public BackgroundPathAndBytesable<Stat> withVersion(int version) {
        this.version = version;
        return this;
    }

    @Override
    public ErrorListenerPathAndBytesable<Stat> inBackground(BackgroundCallback callback, Object context) {
        this.backgrounding = new Backgrounding(callback, context);
        return this;
    }

    @Override
    public ErrorListenerPathAndBytesable<Stat> inBackground(BackgroundCallback callback, Object context, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, context, executor);
        return this;
    }

    @Override
    public ErrorListenerPathAndBytesable<Stat> inBackground(BackgroundCallback callback) {
        this.backgrounding = new Backgrounding(callback);
        return this;
    }

    @Override
    public ErrorListenerPathAndBytesable<Stat> inBackground() {
        this.backgrounding = new Backgrounding(true);
        return this;
    }

    @Override
    public ErrorListenerPathAndBytesable<Stat> inBackground(Object context) {
        this.backgrounding = new Backgrounding(context);
        return this;
    }

    @Override
    public ErrorListenerPathAndBytesable<Stat> inBackground(BackgroundCallback callback, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, executor);
        return this;
    }

    @Override
    public PathAndBytesable<Stat> withUnhandledErrorListener(UnhandledErrorListener listener) {
        this.backgrounding = new Backgrounding(this.backgrounding, listener);
        return this;
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<PathAndBytes> operationAndData) throws Exception {
        try {
            final OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("SetDataBuilderImpl-Background");
            final byte[] data2 = operationAndData.getData().getData();
            this.client.getZooKeeper().setData(operationAndData.getData().getPath(), data2, this.version, new AsyncCallback.StatCallback(){

                @Override
                public void processResult(int rc, String path2, Object ctx, Stat stat) {
                    trace.setReturnCode(rc).setRequestBytesLength(data2).setPath(path2).setStat(stat).commit();
                    CuratorEventImpl event = new CuratorEventImpl(SetDataBuilderImpl.this.client, CuratorEventType.SET_DATA, rc, path2, null, ctx, stat, null, null, null, null);
                    SetDataBuilderImpl.this.client.processBackgroundOperation(operationAndData, event);
                }
            }, this.backgrounding.getContext());
        }
        catch (Throwable e2) {
            this.backgrounding.checkError(e2);
        }
    }

    @Override
    public Stat forPath(String path2) throws Exception {
        return this.forPath(path2, this.client.getDefaultData());
    }

    @Override
    public Stat forPath(String path2, byte[] data2) throws Exception {
        if (this.compress) {
            data2 = this.client.getCompressionProvider().compress(path2, data2);
        }
        path2 = this.client.fixForNamespace(path2);
        Stat resultStat = null;
        if (this.backgrounding.inBackground()) {
            this.client.processBackgroundOperation(new OperationAndData<PathAndBytes>(this, new PathAndBytes(path2, data2), this.backgrounding.getCallback(), null, this.backgrounding.getContext()), null);
        } else {
            resultStat = this.pathInForeground(path2, data2);
        }
        return resultStat;
    }

    int getVersion() {
        return this.version;
    }

    private Stat pathInForeground(final String path2, final byte[] data2) throws Exception {
        OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("SetDataBuilderImpl-Foreground");
        Stat resultStat = RetryLoop.callWithRetry(this.client.getZookeeperClient(), new Callable<Stat>(){

            @Override
            public Stat call() throws Exception {
                return SetDataBuilderImpl.this.client.getZooKeeper().setData(path2, data2, SetDataBuilderImpl.this.version);
            }
        });
        trace.setRequestBytesLength(data2).setPath(path2).setStat(resultStat).commit();
        return resultStat;
    }
}

