/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.curator;

import io.mantisrx.shaded.org.apache.curator.ConnectionState;
import io.mantisrx.shaded.org.apache.curator.RetryLoop;
import io.mantisrx.shaded.org.apache.curator.RetryPolicy;
import io.mantisrx.shaded.org.apache.curator.SessionFailRetryLoop;
import io.mantisrx.shaded.org.apache.curator.TimeTrace;
import io.mantisrx.shaded.org.apache.curator.drivers.OperationTrace;
import io.mantisrx.shaded.org.apache.curator.drivers.TracerDriver;
import io.mantisrx.shaded.org.apache.curator.ensemble.EnsembleProvider;
import io.mantisrx.shaded.org.apache.curator.ensemble.fixed.FixedEnsembleProvider;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.base.Preconditions;
import io.mantisrx.shaded.org.apache.curator.utils.DefaultTracerDriver;
import io.mantisrx.shaded.org.apache.curator.utils.DefaultZookeeperFactory;
import io.mantisrx.shaded.org.apache.curator.utils.ThreadUtils;
import io.mantisrx.shaded.org.apache.curator.utils.ZookeeperFactory;
import io.mantisrx.shaded.org.apache.zookeeper.WatchedEvent;
import io.mantisrx.shaded.org.apache.zookeeper.Watcher;
import io.mantisrx.shaded.org.apache.zookeeper.ZooKeeper;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuratorZookeeperClient
implements Closeable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ConnectionState state;
    private final AtomicReference<RetryPolicy> retryPolicy = new AtomicReference();
    private final int connectionTimeoutMs;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicReference<TracerDriver> tracer = new AtomicReference<DefaultTracerDriver>(new DefaultTracerDriver());

    public CuratorZookeeperClient(String connectString, int sessionTimeoutMs, int connectionTimeoutMs, Watcher watcher, RetryPolicy retryPolicy) {
        this(new DefaultZookeeperFactory(), new FixedEnsembleProvider(connectString), sessionTimeoutMs, connectionTimeoutMs, watcher, retryPolicy, false);
    }

    public CuratorZookeeperClient(EnsembleProvider ensembleProvider, int sessionTimeoutMs, int connectionTimeoutMs, Watcher watcher, RetryPolicy retryPolicy) {
        this(new DefaultZookeeperFactory(), ensembleProvider, sessionTimeoutMs, connectionTimeoutMs, watcher, retryPolicy, false);
    }

    public CuratorZookeeperClient(ZookeeperFactory zookeeperFactory, EnsembleProvider ensembleProvider, int sessionTimeoutMs, int connectionTimeoutMs, Watcher watcher, RetryPolicy retryPolicy, boolean canBeReadOnly) {
        if (sessionTimeoutMs < connectionTimeoutMs) {
            this.log.warn(String.format("session timeout [%d] is less than connection timeout [%d]", sessionTimeoutMs, connectionTimeoutMs));
        }
        retryPolicy = Preconditions.checkNotNull(retryPolicy, "retryPolicy cannot be null");
        ensembleProvider = Preconditions.checkNotNull(ensembleProvider, "ensembleProvider cannot be null");
        this.connectionTimeoutMs = connectionTimeoutMs;
        this.state = new ConnectionState(zookeeperFactory, ensembleProvider, sessionTimeoutMs, connectionTimeoutMs, watcher, this.tracer, canBeReadOnly);
        this.setRetryPolicy(retryPolicy);
    }

    public ZooKeeper getZooKeeper() throws Exception {
        Preconditions.checkState(this.started.get(), "Client is not started");
        return this.state.getZooKeeper();
    }

    public RetryLoop newRetryLoop() {
        return new RetryLoop(this.retryPolicy.get(), this.tracer);
    }

    public SessionFailRetryLoop newSessionFailRetryLoop(SessionFailRetryLoop.Mode mode) {
        return new SessionFailRetryLoop(this, mode);
    }

    public boolean isConnected() {
        return this.state.isConnected();
    }

    public boolean blockUntilConnectedOrTimedOut() throws InterruptedException {
        Preconditions.checkState(this.started.get(), "Client is not started");
        this.log.debug("blockUntilConnectedOrTimedOut() start");
        OperationTrace trace = this.startAdvancedTracer("blockUntilConnectedOrTimedOut");
        this.internalBlockUntilConnectedOrTimedOut();
        trace.commit();
        boolean localIsConnected = this.state.isConnected();
        this.log.debug("blockUntilConnectedOrTimedOut() end. isConnected: " + localIsConnected);
        return localIsConnected;
    }

    public void start() throws Exception {
        this.log.debug("Starting");
        if (!this.started.compareAndSet(false, true)) {
            IllegalStateException ise = new IllegalStateException("Already started");
            throw ise;
        }
        this.state.start();
    }

    @Override
    public void close() {
        this.log.debug("Closing");
        this.started.set(false);
        try {
            this.state.close();
        }
        catch (IOException e2) {
            ThreadUtils.checkInterrupted(e2);
            this.log.error("", e2);
        }
    }

    public void setRetryPolicy(RetryPolicy policy) {
        Preconditions.checkNotNull(policy, "policy cannot be null");
        this.retryPolicy.set(policy);
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy.get();
    }

    public TimeTrace startTracer(String name2) {
        return new TimeTrace(name2, this.tracer.get());
    }

    public OperationTrace startAdvancedTracer(String name2) {
        return new OperationTrace(name2, this.tracer.get(), this.state.getSessionId());
    }

    public TracerDriver getTracerDriver() {
        return this.tracer.get();
    }

    public void setTracerDriver(TracerDriver tracer) {
        this.tracer.set(tracer);
    }

    public String getCurrentConnectionString() {
        return this.state.getEnsembleProvider().getConnectionString();
    }

    public int getConnectionTimeoutMs() {
        return this.connectionTimeoutMs;
    }

    public long getInstanceIndex() {
        return this.state.getInstanceIndex();
    }

    void addParentWatcher(Watcher watcher) {
        this.state.addParentWatcher(watcher);
    }

    void removeParentWatcher(Watcher watcher) {
        this.state.removeParentWatcher(watcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalBlockUntilConnectedOrTimedOut() throws InterruptedException {
        long elapsed;
        for (long waitTimeMs = (long)this.connectionTimeoutMs; !this.state.isConnected() && waitTimeMs > 0L; waitTimeMs -= elapsed) {
            final CountDownLatch latch = new CountDownLatch(1);
            Watcher tempWatcher = new Watcher(){

                @Override
                public void process(WatchedEvent event) {
                    latch.countDown();
                }
            };
            this.state.addParentWatcher(tempWatcher);
            long startTimeMs = System.currentTimeMillis();
            try {
                latch.await(1L, TimeUnit.SECONDS);
            }
            finally {
                this.state.removeParentWatcher(tempWatcher);
            }
            elapsed = Math.max(1L, System.currentTimeMillis() - startTimeMs);
        }
    }
}

