/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.com.google.common.primitives;

import io.mantisrx.shaded.com.google.common.annotations.Beta;
import io.mantisrx.shaded.com.google.common.annotations.GwtCompatible;
import io.mantisrx.shaded.com.google.common.base.Preconditions;
import io.mantisrx.shaded.com.google.common.primitives.Ints;
import io.mantisrx.shaded.com.google.common.primitives.ParseRequest;
import java.util.Comparator;

@Beta
@GwtCompatible
public final class UnsignedInts {
    static final long INT_MASK = 0xFFFFFFFFL;

    private UnsignedInts() {
    }

    static int flip(int value) {
        return value ^ Integer.MIN_VALUE;
    }

    public static int compare(int a, int b) {
        return Ints.compare(UnsignedInts.flip(a), UnsignedInts.flip(b));
    }

    public static long toLong(int value) {
        return (long)value & 0xFFFFFFFFL;
    }

    public static int min(int ... array2) {
        Preconditions.checkArgument(array2.length > 0);
        int min2 = UnsignedInts.flip(array2[0]);
        for (int i = 1; i < array2.length; ++i) {
            int next2 = UnsignedInts.flip(array2[i]);
            if (next2 >= min2) continue;
            min2 = next2;
        }
        return UnsignedInts.flip(min2);
    }

    public static int max(int ... array2) {
        Preconditions.checkArgument(array2.length > 0);
        int max2 = UnsignedInts.flip(array2[0]);
        for (int i = 1; i < array2.length; ++i) {
            int next2 = UnsignedInts.flip(array2[i]);
            if (next2 <= max2) continue;
            max2 = next2;
        }
        return UnsignedInts.flip(max2);
    }

    public static String join(String separator, int ... array2) {
        Preconditions.checkNotNull(separator);
        if (array2.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array2.length * 5);
        builder.append(UnsignedInts.toString(array2[0]));
        for (int i = 1; i < array2.length; ++i) {
            builder.append(separator).append(UnsignedInts.toString(array2[i]));
        }
        return builder.toString();
    }

    public static Comparator<int[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static int divide(int dividend, int divisor) {
        return (int)(UnsignedInts.toLong(dividend) / UnsignedInts.toLong(divisor));
    }

    public static int remainder(int dividend, int divisor) {
        return (int)(UnsignedInts.toLong(dividend) % UnsignedInts.toLong(divisor));
    }

    public static int decode(String stringValue) {
        ParseRequest request = ParseRequest.fromString(stringValue);
        try {
            return UnsignedInts.parseUnsignedInt(request.rawValue, request.radix);
        }
        catch (NumberFormatException e2) {
            String string2 = String.valueOf(stringValue);
            NumberFormatException decodeException = new NumberFormatException(string2.length() != 0 ? "Error parsing value: ".concat(string2) : new String("Error parsing value: "));
            decodeException.initCause(e2);
            throw decodeException;
        }
    }

    public static int parseUnsignedInt(String s) {
        return UnsignedInts.parseUnsignedInt(s, 10);
    }

    public static int parseUnsignedInt(String string2, int radix) {
        Preconditions.checkNotNull(string2);
        long result = Long.parseLong(string2, radix);
        if ((result & 0xFFFFFFFFL) != result) {
            String string3 = String.valueOf(String.valueOf(string2));
            int n = radix;
            throw new NumberFormatException(new StringBuilder(69 + string3.length()).append("Input ").append(string3).append(" in base ").append(n).append(" is not in the range of an unsigned integer").toString());
        }
        return (int)result;
    }

    public static String toString(int x) {
        return UnsignedInts.toString(x, 10);
    }

    public static String toString(int x, int radix) {
        long asLong = (long)x & 0xFFFFFFFFL;
        return Long.toString(asLong, radix);
    }

    static enum LexicographicalComparator implements Comparator<int[]>
    {
        INSTANCE;


        @Override
        public int compare(int[] left2, int[] right2) {
            int minLength = Math.min(left2.length, right2.length);
            for (int i = 0; i < minLength; ++i) {
                if (left2[i] == right2[i]) continue;
                return UnsignedInts.compare(left2[i], right2[i]);
            }
            return left2.length - right2.length;
        }
    }
}

