/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.descriptor;

import io.mantisrx.runtime.descriptor.StageDeploymentStrategy;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class DeploymentStrategy {
    private Map<Integer, StageDeploymentStrategy> stages;

    public DeploymentStrategy(@JsonProperty(value="stageDeploymentStrategyMap") Map<Integer, StageDeploymentStrategy> stages) {
        this.stages = stages;
    }

    public StageDeploymentStrategy forStage(int stageNum) {
        if (!this.stages.containsKey(stageNum)) {
            return null;
        }
        return this.stages.get(stageNum);
    }

    public boolean requireInheritInstanceCheck() {
        return this.stages != null && this.stages.values().stream().anyMatch(StageDeploymentStrategy::isInheritInstanceCount);
    }

    public boolean requireInheritInstanceCheck(int stageNum) {
        return this.stages != null && this.stages.containsKey(stageNum) && this.stages.get(stageNum).isInheritInstanceCount();
    }

    public static DeploymentStrategyBuilder builder() {
        return new DeploymentStrategyBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeploymentStrategy)) {
            return false;
        }
        DeploymentStrategy other = (DeploymentStrategy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<Integer, StageDeploymentStrategy> this$stages = this.stages;
        Map<Integer, StageDeploymentStrategy> other$stages = other.stages;
        return !(this$stages == null ? other$stages != null : !((Object)this$stages).equals(other$stages));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeploymentStrategy;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<Integer, StageDeploymentStrategy> $stages = this.stages;
        result = result * 59 + ($stages == null ? 43 : ((Object)$stages).hashCode());
        return result;
    }

    public String toString() {
        return "DeploymentStrategy(stages=" + this.stages + ")";
    }

    public static class DeploymentStrategyBuilder {
        private ArrayList<Integer> stages$key;
        private ArrayList<StageDeploymentStrategy> stages$value;

        DeploymentStrategyBuilder() {
        }

        public DeploymentStrategyBuilder stage(Integer stageKey, StageDeploymentStrategy stageValue) {
            if (this.stages$key == null) {
                this.stages$key = new ArrayList();
                this.stages$value = new ArrayList();
            }
            this.stages$key.add(stageKey);
            this.stages$value.add(stageValue);
            return this;
        }

        public DeploymentStrategyBuilder stages(Map<? extends Integer, ? extends StageDeploymentStrategy> stages) {
            if (stages != null) {
                if (this.stages$key == null) {
                    this.stages$key = new ArrayList();
                    this.stages$value = new ArrayList();
                }
                for (Map.Entry<? extends Integer, ? extends StageDeploymentStrategy> $lombokEntry : stages.entrySet()) {
                    this.stages$key.add($lombokEntry.getKey());
                    this.stages$value.add($lombokEntry.getValue());
                }
            }
            return this;
        }

        public DeploymentStrategyBuilder clearStages() {
            if (this.stages$key != null) {
                this.stages$key.clear();
                this.stages$value.clear();
            }
            return this;
        }

        public DeploymentStrategy build() {
            Map<Integer, StageDeploymentStrategy> stages;
            switch (this.stages$key == null ? 0 : this.stages$key.size()) {
                case 0: {
                    stages = Collections.emptyMap();
                    break;
                }
                case 1: {
                    stages = Collections.singletonMap(this.stages$key.get(0), this.stages$value.get(0));
                    break;
                }
                default: {
                    stages = new LinkedHashMap<Integer, StageDeploymentStrategy>(this.stages$key.size() < 0x40000000 ? 1 + this.stages$key.size() + (this.stages$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.stages$key.size(); ++$i) {
                        stages.put(this.stages$key.get($i), this.stages$value.get($i));
                    }
                    stages = Collections.unmodifiableMap(stages);
                }
            }
            return new DeploymentStrategy(stages);
        }

        public String toString() {
            return "DeploymentStrategy.DeploymentStrategyBuilder(stages$key=" + this.stages$key + ", stages$value=" + this.stages$value + ")";
        }
    }
}

