/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.mantis.remote.observable;

import io.mantisrx.common.codec.Encoder;
import io.reactivex.mantis.remote.observable.MutableReference;
import io.reactivex.mantis.remote.observable.ServeConfig;
import io.reactivex.mantis.remote.observable.filter.ServerSideFilters;
import io.reactivex.mantis.remote.observable.slotting.RoundRobin;
import io.reactivex.mantis.remote.observable.slotting.SlottingStrategy;
import java.util.Map;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.functions.Action0;
import rx.functions.Func1;

public class ServeNestedObservable<T>
extends ServeConfig<T, T> {
    private Encoder<T> encoder;

    public ServeNestedObservable(Builder<T> builder) {
        super(((Builder)builder).name, ((Builder)builder).slottingStrategy, ((Builder)builder).filterFunction, ((Builder)builder).maxWriteAttempts);
        this.encoder = ((Builder)builder).encoder;
        this.applySlottingSideEffectToObservable(((Builder)builder).observable);
    }

    private void applySlottingSideEffectToObservable(Observable<Observable<T>> o) {
        final Observable<T> withSideEffects = Observable.merge(o).doOnEach(new Observer<T>(){

            @Override
            public void onCompleted() {
                ServeNestedObservable.this.slottingStrategy.completeAllConnections();
            }

            @Override
            public void onError(Throwable e2) {
                ServeNestedObservable.this.slottingStrategy.errorAllConnections(e2);
            }

            @Override
            public void onNext(T value) {
                ServeNestedObservable.this.slottingStrategy.writeOnSlot(null, value);
            }
        });
        final MutableReference subscriptionRef = new MutableReference();
        this.slottingStrategy.registerDoAfterFirstConnectionAdded(new Action0(){

            @Override
            public void call() {
                subscriptionRef.setValue(withSideEffects.subscribe());
            }
        });
        this.slottingStrategy.registerDoAfterLastConnectionRemoved(new Action0(){

            @Override
            public void call() {
                ((Subscription)subscriptionRef.getValue()).unsubscribe();
            }
        });
    }

    public Encoder<T> getEncoder() {
        return this.encoder;
    }

    public static class Builder<T> {
        private String name;
        private Observable<Observable<T>> observable;
        private SlottingStrategy<T> slottingStrategy = new RoundRobin();
        private Encoder<T> encoder;
        private Func1<Map<String, String>, Func1<T, Boolean>> filterFunction = ServerSideFilters.noFiltering();
        private int maxWriteAttempts = 3;

        public Builder<T> name(String name2) {
            if (name2 != null && name2.length() > 127) {
                throw new IllegalArgumentException("Observable name must be less than 127 characters");
            }
            this.name = name2;
            return this;
        }

        public Builder<T> observable(Observable<Observable<T>> observable) {
            this.observable = observable;
            return this;
        }

        public Builder<T> maxWriteAttempts(int maxWriteAttempts) {
            this.maxWriteAttempts = maxWriteAttempts;
            return this;
        }

        public Builder<T> slottingStrategy(SlottingStrategy<T> slottingStrategy) {
            this.slottingStrategy = slottingStrategy;
            return this;
        }

        public Builder<T> encoder(Encoder<T> encoder) {
            this.encoder = encoder;
            return this;
        }

        public Builder<T> serverSideFilter(Func1<Map<String, String>, Func1<T, Boolean>> filterFunc) {
            this.filterFunction = filterFunc;
            return this;
        }

        public ServeNestedObservable<T> build() {
            return new ServeNestedObservable(this);
        }
    }
}

