/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.mantis.remote.observable;

import io.mantisrx.common.network.Endpoint;
import io.reactivex.mantis.remote.observable.ConnectToGroupedObservable;
import io.reactivex.mantis.remote.observable.ConnectToObservable;
import io.reactivex.mantis.remote.observable.EndpointChange;
import io.reactivex.mantis.remote.observable.EndpointInjector;
import io.reactivex.mantis.remote.observable.MergedObservable;
import io.reactivex.mantis.remote.observable.RemoteObservable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Action1;
import rx.functions.Func1;
import rx.observables.GroupedObservable;
import rx.subscriptions.BooleanSubscription;

public class FixedConnectionSet<T> {
    private static final Logger logger = LoggerFactory.getLogger(FixedConnectionSet.class);
    private EndpointInjector endpointInjector;
    private Func1<Endpoint, Observable<T>> toObservableFunc;
    private MergedObservable<T> mergedObservable;

    public FixedConnectionSet(int expectedTerminalCount, EndpointInjector endpointInjector, Func1<Endpoint, Observable<T>> toObservableFunc) {
        this.endpointInjector = endpointInjector;
        this.toObservableFunc = toObservableFunc;
        this.mergedObservable = MergedObservable.create(expectedTerminalCount);
    }

    public static <K, V> FixedConnectionSet<GroupedObservable<K, V>> create(int expectedTerminalCount, final ConnectToGroupedObservable.Builder<K, V> config, EndpointInjector endpointService) {
        Func1 toObservableFunc = new Func1<Endpoint, Observable<GroupedObservable<K, V>>>(){

            @Override
            public Observable<GroupedObservable<K, V>> call(Endpoint endpoint) {
                config.host(endpoint.getHost()).port(endpoint.getPort());
                return RemoteObservable.connect(config.build()).getObservable();
            }
        };
        return new FixedConnectionSet<GroupedObservable<K, V>>(expectedTerminalCount, endpointService, toObservableFunc);
    }

    public static <T> FixedConnectionSet<T> create(int expectedTerminalCount, final ConnectToObservable.Builder<T> config, EndpointInjector endpointService) {
        Func1 toObservableFunc = new Func1<Endpoint, Observable<T>>(){

            @Override
            public Observable<T> call(Endpoint endpoint) {
                config.host(endpoint.getHost()).port(endpoint.getPort());
                return RemoteObservable.connect(config.build()).getObservable();
            }
        };
        return new FixedConnectionSet<T>(expectedTerminalCount, endpointService, toObservableFunc);
    }

    public Observable<Observable<T>> getObservables() {
        return Observable.create(new Observable.OnSubscribe<Observable<T>>(){

            @Override
            public void call(final Subscriber<? super Observable<T>> subscriber2) {
                final BooleanSubscription subscription2 = new BooleanSubscription();
                subscriber2.add(new Subscription(){

                    @Override
                    public void unsubscribe() {
                        FixedConnectionSet.this.mergedObservable.clear();
                        subscription2.unsubscribe();
                    }

                    @Override
                    public boolean isUnsubscribed() {
                        return subscription2.isUnsubscribed();
                    }
                });
                subscriber2.add(FixedConnectionSet.this.mergedObservable.get().subscribe(new Observer<Observable<T>>(){

                    @Override
                    public void onCompleted() {
                        subscriber2.onCompleted();
                    }

                    @Override
                    public void onError(Throwable e2) {
                        subscriber2.onError(e2);
                    }

                    @Override
                    public void onNext(Observable<T> t) {
                        subscriber2.onNext(t);
                    }
                }));
                subscriber2.add(FixedConnectionSet.this.endpointInjector.deltas().subscribe(new Action1<EndpointChange>(){

                    @Override
                    public void call(EndpointChange ec) {
                        String id = Endpoint.uniqueHost(ec.getEndpoint().getHost(), ec.getEndpoint().getPort(), ec.getEndpoint().getSlotId());
                        if (EndpointChange.Type.add == ec.getType()) {
                            logger.info("Adding new connection to host: " + ec.getEndpoint().getHost() + " at port: " + ec.getEndpoint().getPort() + " with id: " + id);
                            FixedConnectionSet.this.mergedObservable.mergeIn(id, (Observable)FixedConnectionSet.this.toObservableFunc.call(ec.getEndpoint()), ec.getEndpoint().getErrorCallback(), ec.getEndpoint().getCompletedCallback());
                        } else if (EndpointChange.Type.complete == ec.getType()) {
                            logger.info("Forcing connection to complete host: " + ec.getEndpoint().getHost() + " at port: " + ec.getEndpoint().getPort() + " with id: " + id);
                            FixedConnectionSet.this.mergedObservable.forceComplete(id);
                        }
                    }
                }));
            }
        });
    }
}

