/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslServerPrincipal {
    private static final Logger LOG = LoggerFactory.getLogger(SaslServerPrincipal.class);
    private static final String ZK_SASL_CLIENT_USERNAME = "zookeeper.sasl.client.username";
    static final String ZK_SASL_CLIENT_CANONICALIZE_HOSTNAME = "zookeeper.sasl.client.canonicalize.hostname";

    static String getServerPrincipal(InetSocketAddress addr) {
        return SaslServerPrincipal.getServerPrincipal(new WrapperInetSocketAddress(addr));
    }

    static String getServerPrincipal(WrapperInetSocketAddress addr) {
        String principalUserName = System.getProperty(ZK_SASL_CLIENT_USERNAME, "zookeeper");
        String hostName = addr.getHostName();
        boolean canonicalize = true;
        String canonicalizeText = System.getProperty(ZK_SASL_CLIENT_CANONICALIZE_HOSTNAME, "true");
        try {
            canonicalize = Boolean.parseBoolean(canonicalizeText);
        }
        catch (IllegalArgumentException ea) {
            LOG.warn("Could not parse config {} \"{}\" into a boolean using default {}", ZK_SASL_CLIENT_CANONICALIZE_HOSTNAME, canonicalizeText, canonicalize);
        }
        if (canonicalize) {
            WrapperInetAddress ia = addr.getAddress();
            if (ia == null) {
                throw new IllegalArgumentException("Unable to canonicalize address " + addr + " because it's not resolvable");
            }
            String canonicalHostName = ia.getCanonicalHostName();
            if (!canonicalHostName.equals(ia.getHostAddress())) {
                hostName = canonicalHostName;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Canonicalized address to {}", (Object)hostName);
            }
        }
        String serverPrincipal = principalUserName + "/" + hostName;
        return serverPrincipal;
    }

    static class WrapperInetAddress {
        private final InetAddress ia;

        WrapperInetAddress(InetAddress ia) {
            this.ia = ia;
        }

        public String getCanonicalHostName() {
            return this.ia.getCanonicalHostName();
        }

        public String getHostAddress() {
            return this.ia.getHostAddress();
        }

        public String toString() {
            return this.ia.toString();
        }
    }

    static class WrapperInetSocketAddress {
        private final InetSocketAddress addr;

        WrapperInetSocketAddress(InetSocketAddress addr) {
            this.addr = addr;
        }

        public String getHostName() {
            return this.addr.getHostName();
        }

        public WrapperInetAddress getAddress() {
            InetAddress ia = this.addr.getAddress();
            return ia == null ? null : new WrapperInetAddress(ia);
        }

        public String toString() {
            return this.addr.toString();
        }
    }
}

