/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.curator.framework.recipes.locks;

import io.mantisrx.shaded.org.apache.curator.framework.CuratorFramework;
import io.mantisrx.shaded.org.apache.curator.framework.recipes.locks.InterProcessLock;
import io.mantisrx.shaded.org.apache.curator.framework.recipes.locks.InterProcessMutex;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect.ImmutableList;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.collect.Lists;
import io.mantisrx.shaded.org.apache.curator.utils.ThreadUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class InterProcessMultiLock
implements InterProcessLock {
    private final List<InterProcessLock> locks;

    public InterProcessMultiLock(CuratorFramework client, List<String> paths) {
        this(InterProcessMultiLock.makeLocks(client, paths));
    }

    public InterProcessMultiLock(List<InterProcessLock> locks) {
        this.locks = ImmutableList.copyOf(locks);
    }

    private static List<InterProcessLock> makeLocks(CuratorFramework client, List<String> paths) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String path2 : paths) {
            InterProcessMutex lock = new InterProcessMutex(client, path2);
            builder.add(lock);
        }
        return builder.build();
    }

    @Override
    public void acquire() throws Exception {
        this.acquire(-1L, null);
    }

    @Override
    public boolean acquire(long time2, TimeUnit unit) throws Exception {
        Exception exception = null;
        ArrayList<InterProcessLock> acquired = Lists.newArrayList();
        boolean success2 = true;
        for (InterProcessLock lock : this.locks) {
            try {
                if (unit == null) {
                    lock.acquire();
                    acquired.add(lock);
                    continue;
                }
                if (lock.acquire(time2, unit)) {
                    acquired.add(lock);
                    continue;
                }
                success2 = false;
                break;
            }
            catch (Exception e2) {
                ThreadUtils.checkInterrupted(e2);
                success2 = false;
                exception = e2;
            }
        }
        if (!success2) {
            for (InterProcessLock lock : Lists.reverse(acquired)) {
                try {
                    lock.release();
                }
                catch (Exception e3) {
                    ThreadUtils.checkInterrupted(e3);
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
        return success2;
    }

    @Override
    public synchronized void release() throws Exception {
        Exception baseException = null;
        for (InterProcessLock lock : Lists.reverse(this.locks)) {
            try {
                lock.release();
            }
            catch (Exception e2) {
                ThreadUtils.checkInterrupted(e2);
                if (baseException == null) {
                    baseException = e2;
                    continue;
                }
                baseException = new Exception(baseException);
            }
        }
        if (baseException != null) {
            throw baseException;
        }
    }

    @Override
    public synchronized boolean isAcquiredInThisProcess() {
        for (InterProcessLock lock : this.locks) {
            if (lock.isAcquiredInThisProcess()) continue;
            return false;
        }
        return true;
    }
}

