/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.jline;

import io.mantisrx.shaded.jline.ConsoleReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Enumeration;

public class ConsoleReaderInputStream
extends SequenceInputStream {
    private static InputStream systemIn = System.in;

    public static void setIn() throws IOException {
        ConsoleReaderInputStream.setIn(new ConsoleReader());
    }

    public static void setIn(ConsoleReader reader2) {
        System.setIn(new ConsoleReaderInputStream(reader2));
    }

    public static void restoreIn() {
        System.setIn(systemIn);
    }

    public ConsoleReaderInputStream(ConsoleReader reader2) {
        super(new ConsoleEnumeration(reader2));
    }

    private static class ConsoleLineInputStream
    extends InputStream {
        private final ConsoleReader reader;
        private String line = null;
        private int index = 0;
        private boolean eol = false;
        protected boolean wasNull = false;

        public ConsoleLineInputStream(ConsoleReader reader2) {
            this.reader = reader2;
        }

        public int read() throws IOException {
            if (this.eol) {
                return -1;
            }
            if (this.line == null) {
                this.line = this.reader.readLine();
            }
            if (this.line == null) {
                this.wasNull = true;
                return -1;
            }
            if (this.index >= this.line.length()) {
                this.eol = true;
                return 10;
            }
            return this.line.charAt(this.index++);
        }
    }

    private static class ConsoleEnumeration
    implements Enumeration {
        private final ConsoleReader reader;
        private ConsoleLineInputStream next = null;
        private ConsoleLineInputStream prev = null;

        public ConsoleEnumeration(ConsoleReader reader2) {
            this.reader = reader2;
        }

        public Object nextElement() {
            if (this.next != null) {
                ConsoleLineInputStream n = this.next;
                this.prev = this.next;
                this.next = null;
                return n;
            }
            return new ConsoleLineInputStream(this.reader);
        }

        public boolean hasMoreElements() {
            if (this.prev != null && this.prev.wasNull) {
                return false;
            }
            if (this.next == null) {
                this.next = (ConsoleLineInputStream)this.nextElement();
            }
            return this.next != null;
        }
    }
}

